/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.Formatters;
import io.intino.sumus.reporting.model.Period;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class NavigationBuilder {
    private final String reportName;
    private final LocalDate date;
    private final Period period;

    public NavigationBuilder(Dashboard.Report report, LocalDate date, Period period) {
        this.reportName = report.name();
        this.date = date;
        this.period = period;
    }

    public String build(Dashboard.Node node) {
        return "<aside class=\"top-info\">" + this.navTag(node) + "</aside>";
    }

    private String navTag(Dashboard.Node node) {
        return "<div style=\"display: flex;flex-direction: row;align-items: center;\"><h3 class=\"MuiTypography-root MuiTypography-h3 ReportingTypo ReportingTypo-h3\">" + this.reportTag(node) + ". " + this.navigationTag(node) + this.selectTag(node) + "</h3></div>";
    }

    private String reportTag(Dashboard.Node node) {
        if (node.name().isEmpty()) {
            return Formatters.translationMark(this.reportName);
        }
        return "<a onclick=\"" + this.openNodeAction("_All") + "\" class=\"admin\">" + Formatters.translationMark(this.reportName) + "</a>";
    }

    private String navigationTag(Dashboard.Node node) {
        if (node.name().isEmpty()) {
            return "";
        }
        String parent = node.parent() != null ? node.parent().name() : "";
        String name = node.name().replace(parent, "");
        return "<a class=\"navigation-node\" onclick=\"" + this.openNodeAction(parent) + "\">" + parent + "</a>" + name;
    }

    private String dateTag() {
        return "<div><p class=\"MuiTypography-root date\">" + this.period.format(this.date) + "</p></div>";
    }

    private String selectTag(Dashboard.Node node) {
        if (node.children().isEmpty()) {
            return "";
        }
        return "<select onchange=\"" + this.openNodeActionRaw("this.value") + "\"><option value='' selected></option>" + this.optionTags(node.children()) + "</select>";
    }

    private String optionTags(List<Dashboard.Node> nodes) {
        return nodes.stream().filter(n -> !n.name().isEmpty()).sorted(Comparator.comparing(Dashboard.Node::name)).map(this::optionTag).collect(Collectors.joining(""));
    }

    private String optionTag(Dashboard.Node node) {
        String parent = node.parent() != null ? node.parent().name() + "." : "";
        String subName = node.name().replace(parent, "");
        return "<option value='" + node.name() + "'>" + subName + "</option>";
    }

    private String openNodeAction(String name) {
        return this.openNodeActionRaw("'" + name + "'");
    }

    private String openNodeActionRaw(String name) {
        return "javascript:openNode(" + name + ")";
    }
}

