/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.aggregators;

import io.intino.alexandria.Timetag;
import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.reporting.exceptions.AggregationException;
import io.intino.sumus.reporting.helpers.ResourceHelper;
import io.intino.sumus.reporting.model.Scale;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LedgerAggregator {
    private final File root;

    public LedgerAggregator(File root) {
        this.root = root;
    }

    public void aggregate(String ledger, Timetag timetag) throws AggregationException, FileNotFoundException, ParseException {
        new Aggregator(ledger, timetag).aggregate();
    }

    private class Aggregator {
        private final String ledger;
        private final LedgerDefinition definition;
        private final Timetag timetag;

        public Aggregator(String ledger, Timetag timetag) throws FileNotFoundException, ParseException {
            this.ledger = ledger;
            this.definition = this.loadDefinition(ledger);
            this.timetag = timetag;
        }

        public void aggregate() throws AggregationException {
            if (this.is(LedgerDefinition.Content.Master) || !this.hasAggregations() || !this.ledgerFolder().exists()) {
                return;
            }
            if (this.is(LedgerDefinition.Content.Events)) {
                this.aggregateEvents();
            }
        }

        private void aggregateEvents() throws AggregationException {
            Function<String, String> function = this.keyFunction();
            this.definition.aggregations.forEach(aggregation -> this.aggregate((LedgerDefinition.Aggregation)aggregation, function));
        }

        private void aggregate(LedgerDefinition.Aggregation aggregation, Function<String, String> function) {
            Timetag from = this.getFrom(aggregation);
            if (function == null) {
                this.aggregateAll(aggregation, from, this.timetag);
            } else {
                this.aggregateFilter(aggregation, from, this.timetag, function);
            }
        }

        private void aggregateAll(LedgerDefinition.Aggregation aggregation, Timetag from, Timetag to) {
            List lines = this.stream(from, to).collect(Collectors.toCollection(LinkedList::new));
            File file = this.ledger(to, aggregation);
            ResourceHelper.truncate(file, lines);
        }

        private void aggregateFilter(LedgerDefinition.Aggregation aggregation, Timetag from, Timetag to, Function<String, String> function) {
            LinkedHashMap records = new LinkedHashMap();
            this.stream(from, to).forEach(line -> {
                String key = (String)function.apply((String)line);
                if (key != null) {
                    records.put(key, line);
                }
            });
            File file = this.ledger(to, aggregation);
            ResourceHelper.truncate(file, records.values());
        }

        private Stream<String> stream(Timetag from, Timetag to) {
            return StreamSupport.stream(from.iterateTo(to).spliterator(), false).map(this::ledger).flatMap(f -> ResourceHelper.lines(f).stream()).filter(l -> l != null && !l.isEmpty());
        }

        private Function<String, String> keyFunction() throws AggregationException {
            String key = this.definition.aggregationKey;
            if (key == null) {
                return null;
            }
            int index = this.attributeIndex(key);
            if (index < 0) {
                throw new AggregationException("Aggregation key attribute " + key + " not found in ledger " + this.ledger);
            }
            return line -> line.split("\t", -1)[index];
        }

        private int attributeIndex(String aggregationKey) {
            List attributes = this.definition.attributes.stream().map(AttributeDefinition::name).collect(Collectors.toList());
            return attributes.indexOf(aggregationKey);
        }

        private LedgerDefinition loadDefinition(String ledger) throws ParseException, FileNotFoundException {
            File file = new File(LedgerAggregator.this.root, ledger + ".ledger");
            if (!file.exists()) {
                throw new FileNotFoundException("Ledger definition " + ledger + " not found");
            }
            return LedgerDefinition.load((File)LedgerAggregator.this.root, (File)file);
        }

        private File ledger(Timetag timetag) {
            return new File(this.ledgerFolder(), timetag + ".tsv");
        }

        private File ledger(Timetag timetag, LedgerDefinition.Aggregation aggregation) {
            File folder = new File(LedgerAggregator.this.root, this.ledger + this.tag(aggregation));
            folder.mkdirs();
            return new File(folder, timetag + ".tsv");
        }

        private File ledgerFolder() {
            return new File(LedgerAggregator.this.root, this.ledger);
        }

        private Timetag getFrom(LedgerDefinition.Aggregation aggregation) {
            LocalDate date = this.timetag.datetime().toLocalDate();
            switch (aggregation) {
                case Week: {
                    return this.toTimetag(Scale.Week.startDate(date));
                }
                case Month: {
                    return this.toTimetag(Scale.Month.startDate(date));
                }
                case Year: {
                    return this.toTimetag(Scale.Year.startDate(date));
                }
            }
            return this.timetag;
        }

        private String tag(LedgerDefinition.Aggregation aggregation) {
            switch (aggregation) {
                case Week: {
                    return "-w";
                }
                case Month: {
                    return "-m";
                }
                case Year: {
                    return "-y";
                }
            }
            return "-unknown";
        }

        private Timetag toTimetag(LocalDate date) {
            return Timetag.of((LocalDate)date, (io.intino.alexandria.Scale)io.intino.alexandria.Scale.Day);
        }

        private boolean is(LedgerDefinition.Content content) {
            return this.definition.content == content;
        }

        private boolean hasAggregations() {
            return !this.definition.aggregations.isEmpty();
        }
    }
}

