/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.Formatters;
import io.intino.sumus.reporting.helpers.JsonHelper;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonBuilder
implements TemplateBuilder {
    private final Dashboard.View view;

    public JsonBuilder(Dashboard.View view) {
        this.view = view;
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        ArrayList<String> records = new ArrayList<String>();
        for (Cube.Cell cell : cube.cells()) {
            Map<String, Double> indicatorMap;
            if (this.isInvalid(cell) || this.missingDimensions(cell) || this.wrongLevel(cell) || this.areAllValuesZero(indicatorMap = this.indicatorValueMap(cell))) continue;
            records.add(this.record(cell, indicatorMap));
        }
        return JsonHelper.array(records);
    }

    private String record(Cube.Cell cell, Map<String, Double> indicatorMap) {
        String[] parameters = (String[])Stream.of(this.label(), this.slicesAttributes(cell), this.indicatorsAttributes(indicatorMap)).filter(v -> v != null && !v.isEmpty()).toArray(String[]::new);
        return JsonHelper.object(parameters);
    }

    private String label() {
        if (this.view.label() == null) {
            return "";
        }
        return JsonHelper.string("_label") + ":" + JsonHelper.string(this.view.label());
    }

    private boolean areAllValuesZero(Map<String, Double> indicatorMap) {
        return indicatorMap.isEmpty() || indicatorMap.values().stream().allMatch(i -> i == 0.0);
    }

    private Map<String, Double> indicatorValueMap(Cube.Cell cell) {
        return cell.indicators().stream().filter(this::isAllowed).collect(Collectors.toMap(Cube.Indicator::name, i -> this.parseDouble(i.value())));
    }

    private boolean missingDimensions(Cube.Cell cell) {
        List viewDimensions = Arrays.stream(this.view.dimensions()).collect(Collectors.toList());
        if (viewDimensions.isEmpty()) {
            return false;
        }
        List cellDimensions = cell.slices().stream().map(s -> s.dimension().name()).collect(Collectors.toList());
        return !cellDimensions.contains(viewDimensions.get(0));
    }

    private boolean wrongLevel(Cube.Cell cell) {
        if (this.view.level() == null) {
            return false;
        }
        for (Slice slice : cell.slices()) {
            List slices = slice.dimension().slices(this.view.level().intValue());
            if (!slices.stream().noneMatch(s -> s.name().equalsIgnoreCase(slice.name()))) continue;
            return true;
        }
        return false;
    }

    private boolean isInvalid(Cube.Cell cell) {
        if (cell == null) {
            return true;
        }
        return cell.slices().isEmpty() && this.view.dimensions().length > 0;
    }

    private boolean isAllowed(Cube.Indicator indicator) {
        return Arrays.stream(this.view.indicators()).anyMatch(i -> i.equalsIgnoreCase(indicator.name()));
    }

    private String indicatorsAttributes(Map<String, Double> indicatorMap) {
        return indicatorMap.entrySet().stream().map(e -> JsonHelper.string((String)e.getKey()) + ":" + e.getValue()).collect(Collectors.joining(","));
    }

    private String slicesAttributes(Cube.Cell cell) {
        return Arrays.stream(this.view.dimensions()).map(dimension -> {
            Slice slice = cell.slices().stream().filter(s -> s.dimension().name().equalsIgnoreCase((String)dimension)).findFirst().orElse(null);
            String label = slice != null ? Formatters.labelByLevel(slice.name(), this.view.level()) : "_All";
            return JsonHelper.string(dimension) + ":" + JsonHelper.string(label);
        }).collect(Collectors.joining(","));
    }

    private double parseDouble(Object object) {
        try {
            double v = Double.parseDouble(object.toString());
            return (double)Math.round(v * 100.0) / 100.0;
        }
        catch (Throwable e) {
            return 0.0;
        }
    }
}

