/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.helpers;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.Slice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CubesHelper {
    public static Cube.Indicator indicatorOf(Cube.Cell cell, String name) {
        if (cell == null) {
            return Cube.Indicator.None;
        }
        Cube.Indicator indicator = cell.indicator(name);
        return indicator != null ? indicator : Cube.Indicator.None;
    }

    public static Cube emptyCube() {
        return new Cube(){

            public List<Dimension> dimensions() {
                return Collections.emptyList();
            }

            public List<Cube.Cell> cells() {
                return Collections.emptyList();
            }

            public Map<String, Cube.Cell> cellMap() {
                return Collections.emptyMap();
            }

            public Iterable<Fact> facts(Filter filter) {
                return Collections::emptyIterator;
            }
        };
    }

    public static List<Slice> slices(Ledger ledger, List<String> rawSlices) {
        ArrayList<Slice> slices = new ArrayList<Slice>();
        CubesHelper.groupByDimension(rawSlices).forEach((dimension, values) -> {
            ArrayList<String> negatives = new ArrayList<String>();
            for (String value : values) {
                if (value.startsWith("!")) {
                    negatives.add(value.substring(1));
                    continue;
                }
                slices.add(ledger.slice(dimension, value));
            }
            slices.addAll(CubesHelper.slicesExcluded(ledger, dimension, negatives));
        });
        return slices;
    }

    private static Map<String, List<String>> groupByDimension(List<String> slices) {
        return slices.stream().map(s -> s.split(":")).collect(Collectors.groupingBy(d -> d[0], Collectors.mapping(d -> d[1], Collectors.toList())));
    }

    private static List<Slice> slicesExcluded(Ledger ledger, String dimension, List<String> excluded) {
        if (excluded.isEmpty()) {
            return new ArrayList<Slice>();
        }
        return ledger.dimension(dimension).slices().stream().filter(s -> excluded.stream().noneMatch(e -> e.equalsIgnoreCase(s.name()))).collect(Collectors.toList());
    }
}

