/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.html.Gauge;
import io.intino.sumus.reporting.templates.html.Microsite;
import java.util.Map;

public class GaugeChartBuilder
implements TemplateBuilder {
    private static final String Red = "#E21A1B";
    private static final String Yellow = "#F2B635";
    private static final String Green = "#2E8900";
    private final Dashboard.Insight insight;
    private final Dashboard.Report report;
    private final Microsite microsite;

    public GaugeChartBuilder(Dashboard.Report report, Dashboard.Insight insight, Microsite microsite) {
        this.report = report;
        this.insight = insight;
        this.microsite = microsite;
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        return new Gauge(this.insight.id(), this.insight.label()).value(this.value(cube)).onClick(this.onClickAction(node)).html();
    }

    private Double value(Cube cube) {
        Cube.Cell cell = cube.cell("");
        String indicator = this.insight.indicators()[0];
        return CubesHelper.doubleValueOf(CubesHelper.indicatorOf(this.report, cell, indicator));
    }

    private Map<Double, String> stops() {
        return this.insight.type() == Dashboard.Insight.Type.Gauge ? Map.of(0.0, Red, 0.49, Red, 0.5, Yellow, 0.74, Yellow, 0.75, Green, 1.0, Green) : Map.of(0.0, Yellow, 0.49, Yellow, 0.5, Red, 1.0, Red);
    }

    private String onClickAction(Dashboard.Node node) {
        return this.microsite.action(node, new Slice[0]);
    }
}

