/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.loaders;

import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.LedgerDecorator;
import io.intino.sumus.engine.ledgers.columnar.ColumnarLedger;
import io.intino.sumus.engine.ledgers.columnar.ColumnarLedgerDecorator;
import io.intino.sumus.engine.ledgers.composite.CompositeLedger;
import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.reporting.exceptions.LedgerNotFoundException;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.model.Period;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;

public class LedgerLoader {
    private final File folder;
    private final LedgerDecorator<ColumnarLedger> decorator;

    public LedgerLoader(File folder) {
        this.folder = folder;
        this.decorator = new ColumnarLedgerDecorator(folder);
    }

    public Ledger ledger(String name, Period period, LocalDate date) {
        try {
            return this.ledger(name, period.dates(date));
        }
        catch (LedgerNotFoundException e) {
            return null;
        }
        catch (Throwable e) {
            System.err.println("Error loading ledger: " + name + " - " + date);
            return null;
        }
    }

    private Ledger ledger(String name, List<LocalDate> dates) throws IOException, LedgerNotFoundException, ParseException {
        LedgerDefinition definition = this.definition(name);
        CompositeLedger compositeLedger = new CompositeLedger("date");
        List ledgers = dates.stream().map(d -> this.ledgerFile(name, (LocalDate)d)).collect(Collectors.toList());
        if (ledgers.stream().noneMatch(File::exists)) {
            throw new LedgerNotFoundException();
        }
        for (LocalDate date : dates) {
            File file = this.ledgerFile(name, date);
            if (!file.exists()) continue;
            compositeLedger.add(this.ledger(definition, file), date);
        }
        return compositeLedger;
    }

    private Ledger ledger(LedgerDefinition definition, File file) throws IOException {
        return this.decorator.decorate((Ledger)new ColumnarLedger(definition).load(file, "\t"));
    }

    private LedgerDefinition definition(String type) throws ParseException {
        return LedgerDefinition.load((File)this.folder, (File)new File(this.folder, type + ".ledger"));
    }

    private File ledgerFile(String type, LocalDate date) {
        return new File(this.folder, type + "/" + FormatHelper.timetag(date) + ".tsv");
    }
}

