/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates.html;

import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.Formatters;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class Pie {
    private final String id;
    private final String title;
    private final List<Slice> slices = new LinkedList<Slice>();
    private Dashboard.Insight.Order order = Dashboard.Insight.Order.Descending;

    public Pie(String id, String title) {
        this.id = id;
        this.title = title;
    }

    public Pie add(Slice slice) {
        this.slices.add(slice);
        return this;
    }

    public Pie order(Dashboard.Insight.Order order) {
        this.order = order;
        return this;
    }

    private String total() {
        return Formatters.format(this.slices.stream().mapToDouble(v -> v.data).sum());
    }

    private String json() {
        return "[" + this.slices.stream().sorted(this.sortAlgorithm()).map(Slice::json).collect(Collectors.joining(",")) + "]";
    }

    public String html() {
        return "<div id=\"" + this.id + "\" class=\"chart pie\"></div><script>pie('" + this.id + "', '" + Formatters.translationMark(this.title) + "', '" + this.total() + "', " + this.json() + ");</script>";
    }

    private Comparator<Slice> sortAlgorithm() {
        if (this.order == Dashboard.Insight.Order.Ascending) {
            return Comparator.comparingDouble(slice -> slice.data);
        }
        return (s1, s2) -> Double.compare(s2.data, s1.data);
    }

    public static class Slice {
        String name;
        double data;
        String onClick;

        public Slice(String name, double value) {
            this.name = name;
            this.data = value;
        }

        public Slice onClick(String onClick) {
            this.onClick = onClick;
            return this;
        }

        public String json() {
            return "{ name: '" + Formatters.translationMark(this.name) + "', y: " + this.data + ", className: '" + this.className() + "'" + this.customs() + "}";
        }

        private String className() {
            return "pie-slice-" + this.name.toLowerCase().replace(" ", "");
        }

        private String customs() {
            return this.onClick != null ? ", custom: { onClick: function(){" + this.onClick + "}}" : "";
        }
    }
}

