/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Column {
    private final String id;
    private final String title;
    private final Set<String> categories = new LinkedHashSet<String>();
    private final Map<String, Serie> seriesMap = new LinkedHashMap<String, Serie>();

    public Column(String id, String title) {
        this.id = id;
        this.title = title;
    }

    public Column add(String ... categories) {
        this.categories.addAll(Arrays.asList(categories));
        return this;
    }

    public Column add(Serie serie) {
        if (!this.seriesMap.containsKey(serie.name)) {
            this.seriesMap.put(serie.name, serie);
        }
        return this;
    }

    public Column add(String serie, long value) {
        this.seriesMap.putIfAbsent(serie, new Serie(serie));
        this.seriesMap.get(serie).add(value);
        return this;
    }

    private String categoriesJson() {
        return "[" + this.categories.stream().map(c -> "'" + c + "'").collect(Collectors.joining(",")) + "]";
    }

    private String seriesJson() {
        return "[" + this.seriesMap.values().stream().map(Serie::json).collect(Collectors.joining(",")) + "]";
    }

    public String html() {
        return "<div id=\"" + this.id + "\" class=\"chart column\"></div><script>column('" + this.id + "', '" + this.title + "'," + this.categoriesJson() + "," + this.seriesJson() + ")</script>";
    }

    public Serie get(String series) {
        return this.seriesMap.get(series);
    }

    public static class Serie {
        private final String name;
        private final List<Long> values = new ArrayList<Long>();
        private String onClick;

        public Serie(String name) {
            this.name = name;
        }

        public List<Long> values() {
            return this.values;
        }

        public Serie add(long value) {
            this.values.add(value);
            return this;
        }

        public Serie onClick(String onClick) {
            this.onClick = onClick;
            return this;
        }

        public String json() {
            return "{ name:'" + this.name + "', data: " + this.dataJson() + "}";
        }

        private String dataJson() {
            return "[" + this.values.stream().map(v -> "{ y: " + v + ", className: '" + this.className() + "'" + this.customs() + "}").collect(Collectors.joining(", ")) + "]";
        }

        private String className() {
            return "column-series-" + this.name.replace(" ", "").toLowerCase();
        }

        private String customs() {
            return this.onClick != null ? ", custom: { onClick: function(){" + this.onClick + "}}" : "";
        }
    }
}

