/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.JsonHelper;
import io.intino.sumus.reporting.insights.TimelineInsight;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ViewBuilder
implements TemplateBuilder {
    private final TimelineInsight insight;
    private final LocalDate date;
    private final String report;

    public ViewBuilder(Dashboard.Insight insight, LocalDate date, String report) {
        this.insight = new TimelineInsight(insight);
        this.date = date;
        this.report = report;
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        return this.insight.type() == Dashboard.Insight.Type.LineView ? this.buildEvolution(node) : (this.insight.type() == Dashboard.Insight.Type.HeatmapView ? this.buildHeatMap(node) : (this.insight.type() == Dashboard.Insight.Type.ColumnView ? this.buildColumn(node) : (this.insight.type() == Dashboard.Insight.Type.ColumnSwapView ? this.buildColumnSwap(node) : this.buildTable(node))));
    }

    private String buildTable(Dashboard.Node node) {
        String tableID = this.insight.id() + "-table";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\"><table id=\"" + tableID + "\" class=\"timeline timeline-table\"></table>" + this.select(tableID, "_updateTimelineTable", node) + "</section>";
    }

    private String buildEvolution(Dashboard.Node node) {
        String chartID = this.insight.id() + "-chart";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\">" + this.select(chartID, "_updateTimelineLineChart", node) + "<div id=\"" + chartID + "\" class=\"timeline timeline-evolution\"></div></section>";
    }

    private String buildHeatMap(Dashboard.Node node) {
        String chartID = this.insight.id() + "-chart";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\">" + this.select(chartID, "_updateTimelineHeatmapChart", node) + "<div id=\"" + chartID + "\" class=\"timeline timeline-heatmap\"></div></section>";
    }

    private String buildColumn(Dashboard.Node node) {
        String chartID = this.insight.id() + "-chart";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\">" + this.select(chartID, "_updateTimelineColumnChart", node) + "<div id=\"" + chartID + "\" class=\"timeline timeline-column\"></div></section>";
    }

    private String buildColumnSwap(Dashboard.Node node) {
        String chartID = this.insight.id() + "-chart";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\">" + this.select(chartID, "_updateTimelineColumnSwapChart", node) + "<div id=\"" + chartID + "\" class=\"timeline timeline-column\"></div></section>";
    }

    private String select(String id, String function, Dashboard.Node node) {
        return "<select class=\"timeline\" onchange=\"" + function + "('" + id + "'," + this.config(node) + "," + this.dates() + ",'" + this.insight.label() + "', this)\"><option value=\"_All\">::All::</option></select>";
    }

    private String config(Dashboard.Node node) {
        return JsonHelper.object("report: '" + this.report + "'", "ledger: '" + this.insight.ledger() + "'", "view: '" + this.insight.view() + "'", "indicator: '" + this.insight.indicator() + "'", "dimension: " + (String)(this.insight.drillDimension() != null ? "'" + this.insight.drillDimension() + "'" : "undefined"), "dimension2: '" + this.insight.filterDimension() + "'", "nodeDimension: '" + node.dimension() + "'", "filters: " + this.escapedArray(this.insight.filters()), "node: '" + node.name() + "'", "isNav: " + this.isNavigable(node), "plotLines: " + this.plotLines(), "slices: " + (this.insight.slices().length > 0 ? this.escapedArray(this.insight.slices()) : "undefined"), "labels: " + this.labels());
    }

    private String labels() {
        String[] labels = (String[])this.insight.labels().entrySet().stream().map(e -> "'" + (String)e.getKey() + "':'" + (String)e.getValue() + "'").toArray(String[]::new);
        return JsonHelper.object(labels);
    }

    private String dates() {
        Period period = this.insight.period();
        Period timeUnit = this.insight.timeUnit();
        Scale timeUnitScale = timeUnit.scale();
        List<LocalDate> dates = period.isSingle() ? this.naturalDates(period) : period.dates(this.date);
        HashSet<String> labels = new HashSet<String>();
        LinkedList<LocalDate> uniques = new LinkedList<LocalDate>();
        for (LocalDate d2 : dates) {
            String timetag = timeUnitScale.timetag(d2);
            if (labels.contains(timetag)) continue;
            labels.add(timetag);
            uniques.add(d2);
        }
        return JsonHelper.array((String[])uniques.stream().map(d -> this.toJson(timeUnit, timeUnitScale, (LocalDate)d)).toArray(String[]::new));
    }

    private String toJson(Period timeUnit, Scale timeUnitScale, LocalDate d) {
        String start = Scale.Day.timetag(timeUnit.onlyLast() ? timeUnitScale.endDate(d) : timeUnitScale.startDate(d));
        String end = Scale.Day.timetag(timeUnitScale.endDate(d));
        return JsonHelper.object("timetag: '" + timeUnitScale.timetag(d) + "'", "label: '" + timeUnitScale.label(d) + "'", "format: '" + timeUnitScale.format(d) + "'", "start:'" + start + "'", "end:'" + end + "'");
    }

    private List<LocalDate> naturalDates(Period period) {
        Scale scale = period.scale();
        LocalDate start = scale.startDate(this.date);
        LocalDate end = scale.endDate(this.date);
        return start.datesUntil(end.plusDays(1L)).collect(Collectors.toList());
    }

    private String plotLines() {
        String value = this.insight.plotLines();
        if (value == null) {
            return "[]";
        }
        String[] plotLines = (String[])Arrays.stream(value.split(",")).map(line -> {
            String[] d = line.split(":");
            if (d.length < 1) {
                return null;
            }
            return JsonHelper.object("value: " + d[0], "name: " + (String)(d.length > 1 ? "'" + d[1] + "'" : "undefined"), "color: " + (String)(d.length > 2 ? "'" + d[2] + "'" : "undefined"));
        }).filter(Objects::nonNull).toArray(String[]::new);
        return JsonHelper.array(plotLines);
    }

    private boolean isNavigable(Dashboard.Node node) {
        return this.insight.navFilterEnabled() && this.insight.dimensions().length == 1 && this.insight.dimensions()[0].equalsIgnoreCase(node.dimension());
    }

    private String escapedArray(String ... values) {
        return JsonHelper.array(v -> "'" + v + "'", values);
    }
}

