/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.loaders;

import io.intino.sumus.reporting.Dashboard;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NodeLoader {
    private final Map<String, Dashboard.Node> nodeMap = new HashMap<String, Dashboard.Node>();
    private final String dimension;
    private final Set<String> names;

    public NodeLoader(String dimension, Set<String> values) {
        this.dimension = dimension;
        this.names = values;
    }

    public List<Dashboard.Node> nodes() {
        for (String name : this.names) {
            this.getOrCreate(name);
        }
        ArrayList<Dashboard.Node> nodes = new ArrayList<Dashboard.Node>(this.nodeMap.values());
        nodes.add(this.globalNode(nodes));
        return nodes;
    }

    private Dashboard.Node getOrCreate(String name) {
        if (!this.nodeMap.containsKey(name) && this.names.contains(name)) {
            this.nodeMap.put(name, this.nodeOf(name));
        }
        return this.nodeMap.get(name);
    }

    private Dashboard.Node nodeOf(final String name) {
        return new Dashboard.Node(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public String dimension() {
                return NodeLoader.this.dimension;
            }

            @Override
            public Dashboard.Node parent() {
                if (!name.contains(".")) {
                    return null;
                }
                return NodeLoader.this.getOrCreate(name.substring(0, name.lastIndexOf(46)));
            }

            @Override
            public List<Dashboard.Node> children() {
                return NodeLoader.this.names.stream().filter(o -> o.startsWith(name + ".")).filter(o -> !o.replace(name + ".", "").contains(".")).map(n -> NodeLoader.this.getOrCreate((String)n)).collect(Collectors.toList());
            }
        };
    }

    public static Set<String> valuesOf(File file) {
        try {
            return Files.lines(file.toPath()).filter(l -> !l.isEmpty()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    private Dashboard.Node globalNode(final List<Dashboard.Node> nodes) {
        return new Dashboard.Node(){

            @Override
            public String name() {
                return "";
            }

            @Override
            public String dimension() {
                return NodeLoader.this.dimension;
            }

            @Override
            public Dashboard.Node parent() {
                return null;
            }

            @Override
            public List<Dashboard.Node> children() {
                return nodes.stream().filter(n -> n.parent() == null).collect(Collectors.toList());
            }
        };
    }
}

