/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.helpers.Formatters;
import io.intino.sumus.reporting.helpers.JsonHelper;
import io.intino.sumus.reporting.helpers.MinifyHelper;
import io.intino.sumus.reporting.helpers.ResourceHelper;
import io.intino.sumus.reporting.helpers.ZipHelper;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.templates.NavigationBuilder;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.TemplateFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DashboardBuilder {
    private static final String BaseHtml = ResourceHelper.getResourceFileAsString("Common.html");
    public static final String GlobalNode = "_All";
    private final Dashboard dashboard;
    private final File folder;

    public DashboardBuilder(Dashboard dashboard, File folder) {
        this.dashboard = dashboard;
        this.folder = new File(folder, dashboard.name());
        this.folder.mkdirs();
    }

    private List<ViewBuilder> viewBuilders(LocalDate date) {
        return this.dashboard.views().stream().map(v -> this.viewBuilder((Dashboard.View)v, date)).collect(Collectors.toList());
    }

    private List<ReportBuilder> reportBuilders(LocalDate date) {
        return this.dashboard.reports().stream().map(report -> this.reportBuilder((Dashboard.Report)report, date)).collect(Collectors.toList());
    }

    private ViewBuilder viewBuilder(Dashboard.View view, LocalDate date) {
        return new ViewBuilder(view, date);
    }

    private ReportBuilder reportBuilder(Dashboard.Report report, LocalDate date) {
        return new ReportBuilder(report, date);
    }

    public synchronized void build(LocalDate date) {
        this.viewBuilders(date).forEach(builder -> builder.build(this.folder));
        this.reportBuilders(date).forEach(builder -> builder.build(this.folder));
    }

    public void build(Dashboard.View view, LocalDate date) {
        this.viewBuilder(view, date).build(this.folder);
    }

    public void build(Dashboard.Report report, LocalDate date) {
        this.reportBuilder(report, date).build(this.folder);
    }

    public String build(Dashboard.Report report, LocalDate date, Dashboard.Node node) {
        return this.reportBuilder(report, date).bodyOf(node);
    }

    private static Filter filterOf(Ledger ledger, Dashboard.Node node, String ... filterNames) {
        List<String> filters = Arrays.stream(filterNames).collect(Collectors.toList());
        if (!node.name().isEmpty()) {
            filters.add(node.filter());
        }
        return DashboardBuilder.filterOf(ledger, filters);
    }

    private static Filter filterOf(Ledger ledger, List<String> slices) {
        return SliceFilter.of(CubesHelper.slices(ledger, slices));
    }

    private static void save(File file, String content) {
        try {
            file.getParentFile().mkdirs();
            Files.write(file.toPath(), content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class ReportBuilder {
        public final Dashboard.Report report;
        private final Period period;
        private final LocalDate date;
        private final List<InsightBuilder> builders;
        private final NavigationBuilder navBuilder;
        private final Map<String, Ledger> ledgers;

        public ReportBuilder(Dashboard.Report report, LocalDate date) {
            this.report = report;
            this.date = date;
            this.period = new Period(Scale.Day);
            this.navBuilder = new NavigationBuilder(report, date, this.period);
            this.ledgers = this.loadLedgers(report, date);
            this.builders = this.loadInsightBuilders(report, date);
        }

        private Map<String, Ledger> loadLedgers(Dashboard.Report report, LocalDate date) {
            return report.ledgers().stream().collect(HashMap::new, (m, l) -> m.put(l, DashboardBuilder.this.dashboard.ledger((String)l, this.period, date)), HashMap::putAll);
        }

        private List<InsightBuilder> loadInsightBuilders(Dashboard.Report report, LocalDate date) {
            return report.insights().stream().map(insight -> new InsightBuilder((Dashboard.Insight)insight, this.period, date)).collect(Collectors.toList());
        }

        protected Ledger getLedger(String ledger) {
            return this.ledgers.get(ledger);
        }

        public void build(File root) {
            if (this.ledgersNotFound()) {
                return;
            }
            this.build(this.folder(root), DashboardBuilder.this.dashboard.nodes());
        }

        private void build(File report, List<Dashboard.Node> nodes) {
            for (Dashboard.Node node : nodes) {
                File file = new File(report, this.filename(node));
                DashboardBuilder.save(file, this.bodyOf(node));
            }
            ZipHelper.zipAndRemove(report);
        }

        public String bodyOf(Dashboard.Node node) {
            String template = this.template(node);
            for (InsightBuilder b : this.builders) {
                template = template.replace(b.mark(), b.bodyOf(node));
            }
            return MinifyHelper.minify(this.replaceGenericMarks(template));
        }

        public File folder(File root) {
            return new File(root, "reports/" + this.report.name() + "/" + this.period.timetag(this.date));
        }

        public String filename(Dashboard.Node node) {
            String name = node.name().isEmpty() ? DashboardBuilder.GlobalNode : node.name();
            return name + ".html";
        }

        private String template(Dashboard.Node node) {
            return DashboardBuilder.this.dashboard.template() + this.navBuilder.build(node) + BaseHtml + this.template();
        }

        private String template() {
            String template = this.report.template();
            if (template != null && !template.isEmpty()) {
                return template;
            }
            return this.builders.stream().map(InsightBuilder::mark).collect(Collectors.joining("\n"));
        }

        private String replaceGenericMarks(String template) {
            return template.replace("::CurrentDay::", Scale.Day.format(this.date)).replace("::CurrentWeekDay::", Scale.Week.format(this.date));
        }

        private boolean ledgersNotFound() {
            return this.ledgers.values().stream().allMatch(Objects::isNull);
        }

        private class InsightBuilder {
            private final Dashboard.Insight insight;
            private final TemplateBuilder builder;

            public InsightBuilder(Dashboard.Insight insight, Period period, LocalDate date) {
                this.insight = insight;
                this.builder = TemplateFactory.builderOf(insight, ReportBuilder.this.report.name(), date, period);
            }

            public String mark() {
                return Formatters.translationMark(this.insight.id());
            }

            public String bodyOf(Dashboard.Node node) {
                if (!this.isVisible(node)) {
                    return "";
                }
                Cube cube = this.cube(node);
                return this.builder.build(cube, node);
            }

            private Cube cube(Dashboard.Node node) {
                Ledger ledger = ReportBuilder.this.getLedger(this.insight.ledger());
                if (ledger == null) {
                    return CubesHelper.emptyCube();
                }
                try {
                    return ledger.cube().dimensions(this.dimensions(ledger)).filter(this.filterOf(ledger, node)).build();
                }
                catch (Throwable e) {
                    return CubesHelper.emptyCube();
                }
            }

            private List<Dimension> dimensions(Ledger ledger) {
                return Arrays.stream(this.insight.dimensions()).map(arg_0 -> ((Ledger)ledger).dimension(arg_0)).collect(Collectors.toList());
            }

            private Filter filterOf(Ledger ledger, Dashboard.Node node) {
                return DashboardBuilder.filterOf(ledger, node, this.insight.filters());
            }

            private boolean isVisible(Dashboard.Node node) {
                return this.insight.visibility().isVisible(node);
            }
        }
    }

    private class ViewBuilder {
        private final Dashboard.View view;
        private final LocalDate date;
        private final Ledger ledger;
        private final TemplateBuilder builder;

        public ViewBuilder(Dashboard.View view, LocalDate date) {
            this.view = view;
            this.date = date;
            this.ledger = DashboardBuilder.this.dashboard.ledger(view.ledger(), view.period(), date);
            this.builder = TemplateFactory.builderOf(view);
        }

        public void build(File root) {
            if (this.ledger == null) {
                return;
            }
            this.build(this.folder(root), DashboardBuilder.this.dashboard.nodes());
        }

        private void build(File view, List<Dashboard.Node> nodes) {
            for (Dashboard.Node node : nodes) {
                File file = new File(view, this.filename(node));
                String content = this.bodyOf(node);
                if (JsonHelper.isEmptyArray(content)) continue;
                DashboardBuilder.save(file, content);
            }
            ZipHelper.zipAndRemove(view);
        }

        public String bodyOf(Dashboard.Node node) {
            return this.builder.build(this.cube(node), node);
        }

        private Cube cube(Dashboard.Node node) {
            try {
                return this.ledger.cube().dimensions(this.dimensions()).filter(this.filterOf(node)).build();
            }
            catch (Throwable e) {
                return CubesHelper.emptyCube();
            }
        }

        private List<Dimension> dimensions() {
            return Arrays.stream(this.view.dimensions()).map(arg_0 -> ((Ledger)this.ledger).dimension(arg_0)).collect(Collectors.toList());
        }

        private Filter filterOf(Dashboard.Node node) {
            return DashboardBuilder.filterOf(this.ledger, node, this.view.filters());
        }

        public File folder(File root) {
            return new File(root, "views/" + this.view.name() + "/" + this.view.period().timetag(this.date));
        }

        public String filename(Dashboard.Node node) {
            String name = node.name().isEmpty() ? DashboardBuilder.GlobalNode : node.name();
            return name + ".json";
        }
    }
}

