/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting;

import io.intino.sumus.engine.Ledger;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import java.io.File;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Dashboard {
    public String name();

    public File datamart();

    public List<Node> nodes();

    public List<Report> reports();

    public List<View> views();

    public Ledger ledger(String var1, Period var2, LocalDate var3);

    default public String template() {
        return "";
    }

    default public boolean isRealtime() {
        return false;
    }

    public static interface Insight {
        public String id();

        public String label();

        public Type type();

        public String ledger();

        public String[] dimensions();

        public String[] filters();

        public String[] indicators();

        public String[] slices();

        public Integer level();

        public Map<String, String> options();

        default public Visibility visibility() {
            return Visibility.All;
        }

        default public Order order() {
            return Order.Descending;
        }

        default public String orderIndicator() {
            return null;
        }

        public Map<String, String> labels();

        default public String translate(String label) {
            return this.labels().getOrDefault(label, label);
        }

        public static enum Visibility {
            All,
            Main,
            Root,
            Leaves,
            AllButLeaves,
            AllButRoot,
            RootWithGrandchildren,
            None;


            public boolean isVisible(Node node) {
                if (None == this) {
                    return false;
                }
                if (Main == this && node.isMain()) {
                    return true;
                }
                if (Root == this && node.isRoot() && !node.isMain()) {
                    return true;
                }
                if (Leaves == this && node.isLeave()) {
                    return true;
                }
                if (AllButLeaves == this && !node.isLeave()) {
                    return true;
                }
                if (AllButRoot == this && !node.isRoot()) {
                    return true;
                }
                if (RootWithGrandchildren == this && node.isRoot() && !node.isMain() && this.hasGrandChildren(node)) {
                    return true;
                }
                return All == this;
            }

            private boolean hasGrandChildren(Node node) {
                return !node.isLeave() && node.children().stream().anyMatch(n -> !n.isLeave());
            }
        }

        public static enum Order {
            Natural,
            Alphabetically,
            Descending,
            Ascending;

        }

        public static enum Type {
            Table,
            TableBar,
            Pie,
            Gauge,
            Column,
            Json,
            Html,
            TableView,
            LineView,
            HeatmapView,
            ColumnView,
            ColumnSwapView;

        }
    }

    public static interface View {
        public String label();

        public String name();

        public String ledger();

        public String[] dimensions();

        public String[] filters();

        public String[] indicators();

        public Integer level();

        default public Period period() {
            return new Period(Scale.Day);
        }
    }

    public static interface Report {
        public String name();

        public String group();

        public String template();

        public Set<String> ledgers();

        public List<Insight> insights();

        default public Period[] periods() {
            return new Period[]{new Period(Scale.Day)};
        }
    }

    public static interface Node {
        public String name();

        public String dimension();

        public Node parent();

        public List<Node> children();

        default public String filter() {
            return this.dimension() + ":" + this.name();
        }

        default public boolean isRoot() {
            return this.parent() == null;
        }

        default public boolean isMain() {
            return this.name().equals("");
        }

        default public boolean isLeave() {
            return this.children().isEmpty();
        }
    }
}

