/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.templates.ColumnChartBuilder;
import io.intino.sumus.reporting.templates.GaugeChartBuilder;
import io.intino.sumus.reporting.templates.HtmlBuilder;
import io.intino.sumus.reporting.templates.JsonBuilder;
import io.intino.sumus.reporting.templates.PieChartBuilder;
import io.intino.sumus.reporting.templates.TableBuilder;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.ViewBuilder;
import io.intino.sumus.reporting.templates.html.Microsite;
import java.time.LocalDate;

public class TemplateFactory {
    public static TemplateBuilder builderOf(Dashboard.Insight insight, String report, LocalDate date, Period period) {
        Microsite microsite = TemplateFactory.microsite(insight, report, date, period);
        Dashboard.Insight.Type type = insight.type();
        if (type == Dashboard.Insight.Type.Table || type == Dashboard.Insight.Type.TableBar) {
            return new TableBuilder(insight, microsite);
        }
        if (type == Dashboard.Insight.Type.Pie) {
            return new PieChartBuilder(insight, microsite);
        }
        if (type == Dashboard.Insight.Type.Gauge) {
            return new GaugeChartBuilder(insight, microsite);
        }
        if (type == Dashboard.Insight.Type.Column) {
            return new ColumnChartBuilder(insight, microsite);
        }
        if (type == Dashboard.Insight.Type.TableView || type == Dashboard.Insight.Type.LineView || type == Dashboard.Insight.Type.HeatmapView || type == Dashboard.Insight.Type.ColumnView || type == Dashboard.Insight.Type.ColumnSwapView) {
            return new ViewBuilder(insight, date, report);
        }
        if (type == Dashboard.Insight.Type.Html) {
            return new HtmlBuilder(insight);
        }
        return (cube, node) -> "";
    }

    public static TemplateBuilder builderOf(Dashboard.View view) {
        return new JsonBuilder(view);
    }

    private static Microsite microsite(Dashboard.Insight insight, String report, LocalDate date, Period period) {
        return new Microsite(insight, report, date, period);
    }
}

