/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.loaders;

import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.LedgerDecorator;
import io.intino.sumus.engine.ledgers.columnar.ColumnarLedger;
import io.intino.sumus.engine.ledgers.columnar.ColumnarLedgerDecorator;
import io.intino.sumus.engine.ledgers.composite.CompositeLedger;
import io.intino.sumus.engine.parser.LedgerDefinition;
import io.intino.sumus.reporting.helpers.Formatters;
import io.intino.sumus.reporting.model.Period;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;

public class LedgerLoader {
    private final File folder;
    private final LedgerDecorator decorator;

    public LedgerLoader(File folder) {
        this.folder = folder;
        this.decorator = new ColumnarLedgerDecorator(folder);
    }

    public Ledger ledger(String name, Period period, LocalDate date) {
        try {
            return this.ledger(name, period.dates(date));
        }
        catch (IOException e) {
            System.err.println("Error loading ledger: " + name + " - " + date);
            return new CompositeLedger("empty");
        }
    }

    private Ledger ledger(String name, List<LocalDate> dates) throws IOException {
        LedgerDefinition definition = this.definition(name);
        CompositeLedger compositeLedger = new CompositeLedger("date");
        for (LocalDate date : dates) {
            File file = this.ledgerFile(name, date);
            if (!file.exists()) continue;
            compositeLedger.add(this.ledger(definition, file), date);
        }
        return compositeLedger;
    }

    private Ledger ledger(LedgerDefinition definition, File file) throws IOException {
        return this.decorator.decorate((Ledger)new ColumnarLedger(definition).load(file, "\t"));
    }

    private LedgerDefinition definition(String type) throws IOException {
        return LedgerDefinition.read((File)new File(this.folder, type + ".ledger"));
    }

    private File ledgerFile(String type, LocalDate date) {
        return new File(this.folder, type + "/" + Formatters.timetag(date) + ".tsv");
    }
}

