/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.helpers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    public static void zipAndRemove(File folder) {
        try {
            ZipHelper.zip(folder);
            ZipHelper.removeRecursively(folder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void zip(File folder) {
        File zip = new File(folder.getParentFile(), folder.getName() + ".zip");
        ZipHelper.zip(zip, folder);
    }

    public static void zip(File zip, File ... files) {
        try {
            if (zip.exists()) {
                zip.delete();
            }
            ZipHelper.write(zip, ZipHelper.entries(files));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void write(File file, Map<String, String> entries) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));){
            entries.forEach((name, content) -> {
                try {
                    zos.putNextEntry(new ZipEntry((String)name));
                    zos.write(content.getBytes());
                    zos.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private static Map<String, String> entries(File ... files) {
        HashMap<String, String> entries = new HashMap<String, String>();
        Arrays.stream(files).forEach(f -> ZipHelper.addEntry(entries, f, f.getName()));
        return entries;
    }

    private static void addEntry(Map<String, String> entries, File file, String entry) {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                ZipHelper.addEntry(entries, subFile, entry + "/" + subFile.getName());
            }
        } else if (file.exists() && file.length() > 0L) {
            entries.put(entry, ZipHelper.content(file));
        }
    }

    private static String content(File file) {
        try {
            return Files.readString(file.toPath());
        }
        catch (Throwable e) {
            return "";
        }
    }

    private static void removeRecursively(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else {
            Files.walk(file.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }
}

