/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.insights.TimelineInsight;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ViewBuilder
implements TemplateBuilder {
    private final TimelineInsight insight;
    private final LocalDate date;
    private final String report;

    public ViewBuilder(Dashboard.Insight insight, LocalDate date, String report) {
        this.insight = new TimelineInsight(insight);
        this.date = date;
        this.report = report;
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        return this.insight.type() == Dashboard.Insight.Type.EvolutionView ? this.buildEvolution(node) : (this.insight.type() == Dashboard.Insight.Type.HeatmapView ? this.buildHeatMap(node) : (this.insight.type() == Dashboard.Insight.Type.ColumnView ? this.buildColumn(node) : (this.insight.type() == Dashboard.Insight.Type.ColumnSwapView ? this.buildColumnSwap(node) : this.buildTable(node))));
    }

    private String buildTable(Dashboard.Node node) {
        String tableID = this.insight.id() + "-table";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\"><table id=\"" + tableID + "\" class=\"timeline timeline-table\"></table>" + this.select(tableID, "_updateTimelineTable", node) + "</section>";
    }

    private String buildEvolution(Dashboard.Node node) {
        String chartID = this.insight.id() + "-chart";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\"><div id=\"" + chartID + "\" class=\"timeline timeline-evolution\"></div>" + this.select(chartID, "_updateTimelineLineChart", node) + "</section>";
    }

    private String buildHeatMap(Dashboard.Node node) {
        String chartID = this.insight.id() + "-chart";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\"><div id=\"" + chartID + "\" class=\"timeline timeline-heatmap\"></div>" + this.select(chartID, "_updateTimelineHeatmapChart", node) + "</section>";
    }

    private String buildColumn(Dashboard.Node node) {
        String chartID = this.insight.id() + "-chart";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\"><div id=\"" + chartID + "\" class=\"timeline timeline-column\"></div>" + this.select(chartID, "_updateTimelineColumnChart", node) + "</section>";
    }

    private String buildColumnSwap(Dashboard.Node node) {
        String chartID = this.insight.id() + "-chart";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\"><div id=\"" + chartID + "\" class=\"timeline timeline-column\"></div>" + this.select(chartID, "_updateTimelineColumnSwapChart", node) + "</section>";
    }

    private String select(String id, String function, Dashboard.Node node) {
        return "<select class=\"timeline\" onchange=\"" + function + "('" + id + "'," + this.config(node) + "," + this.dates() + ",'" + this.insight.label() + "', this)\"><option value=\"_All\">::All::</option></select>";
    }

    private boolean isNavigable(Dashboard.Node node) {
        return this.insight.navFilterEnabled() && this.insight.dimensions().length == 1 && this.insight.dimensions()[0].equalsIgnoreCase(node.dimension());
    }

    private String config(Dashboard.Node node) {
        return "{report: '" + this.report + "', ledger: '" + this.insight.ledger() + "', view: '" + this.insight.view() + "', indicator: '" + this.insight.indicator() + "', dimension: '" + this.insight.drillDimension() + "', dimension2: '" + this.insight.filterDimension() + "', nodeDimension: '" + node.dimension() + "', filters: " + this.toJsonArray(this.insight.filters()) + ",node: '" + node.name() + "', isNav: " + this.isNavigable(node) + ", slices: " + (this.insight.slices().length > 0 ? this.toJsonArray(this.insight.slices()) : "undefined") + "}";
    }

    private String dates() {
        Period period = this.insight.period();
        Period timeUnit = this.insight.timeUnit();
        Scale timeUnitScale = timeUnit.scale();
        List<LocalDate> dates = period.isSingle() ? this.naturalDates(period) : period.dates(this.date);
        HashSet<String> labels = new HashSet<String>();
        LinkedList<LocalDate> uniques = new LinkedList<LocalDate>();
        for (LocalDate d2 : dates) {
            if (labels.contains(timeUnitScale.label(d2))) continue;
            labels.add(timeUnitScale.label(d2));
            uniques.add(d2);
        }
        return "[" + uniques.stream().map(d -> {
            String start = Scale.Day.timetag(timeUnit.onlyLast() ? timeUnitScale.endDate((LocalDate)d) : timeUnitScale.startDate((LocalDate)d));
            String end = Scale.Day.timetag(timeUnitScale.endDate((LocalDate)d));
            return "{timetag: '" + timeUnitScale.timetag((LocalDate)d) + "',label: '" + timeUnitScale.label((LocalDate)d) + "',format: '" + timeUnitScale.format((LocalDate)d) + "',start:'" + start + "',end:'" + end + "'}";
        }).collect(Collectors.joining(",")) + "]";
    }

    private List<LocalDate> naturalDates(Period period) {
        Scale scale = period.scale();
        LocalDate start = scale.startDate(this.date);
        LocalDate end = scale.endDate(this.date);
        return start.datesUntil(end.plusDays(1L)).collect(Collectors.toList());
    }

    private String toJsonArray(String ... values) {
        return "[" + Arrays.stream(values).map(f -> "'" + f + "'").collect(Collectors.joining(",")) + "]";
    }
}

