/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.helpers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class Formatters {
    private static final Locale Locale = java.util.Locale.GERMAN;

    public static String timetag(LocalDate date) {
        return date.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    public static String removeTrailingZeros(double value) {
        return new DecimalFormat("#,##0.#", new DecimalFormatSymbols(Locale)).format(Formatters.round(value, 2));
    }

    public static String format(double value) {
        return NumberFormat.getNumberInstance(Locale).format(Formatters.round(value, 0));
    }

    public static double round(double value, int places) {
        double scale = Math.pow(10.0, places);
        return (double)Math.round(value * scale) / scale;
    }

    public static String translationMark(String name) {
        return name != null && !name.isEmpty() ? "::" + name + "::" : "";
    }
}

