/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.model;

import io.intino.sumus.reporting.model.Scale;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Period {
    private final Scale scale;
    private final int window;
    private boolean onlyLast;

    public Period(Scale scale) {
        this(scale, 1);
    }

    public Period(Scale scale, int window) {
        this.scale = scale;
        this.window = window;
        this.onlyLast = false;
    }

    public Period onlyLast(boolean onlyLast) {
        this.onlyLast = onlyLast;
        return this;
    }

    public Scale scale() {
        return this.scale;
    }

    public int window() {
        return this.window;
    }

    public boolean onlyLast() {
        return this.onlyLast;
    }

    public String windowString() {
        return String.format("%03d", this.window);
    }

    public LocalDate startDate(LocalDate date) {
        if (this.isSingle()) {
            return this.scale.startDate(date);
        }
        int window = this.window - 1;
        if (this.scale == Scale.Week) {
            return date.with(TemporalAdjusters.previous(DayOfWeek.MONDAY)).minus(window, ChronoUnit.WEEKS);
        }
        if (this.scale == Scale.Month) {
            return date.withDayOfMonth(1).minusMonths(window);
        }
        if (this.scale == Scale.Quarter) {
            return date.with(date.getMonth().firstMonthOfQuarter()).withDayOfMonth(1).minusMonths((long)window * 3L);
        }
        if (this.scale == Scale.Year) {
            return date.withDayOfYear(1).minusYears(window);
        }
        return date.minusDays(window);
    }

    public List<LocalDate> dates(LocalDate date) {
        if (this.isSingle() && this.onlyLast()) {
            return this.isLastDay(date) ? Collections.singletonList(date) : Collections.emptyList();
        }
        if (this.isSingle()) {
            return this.scale.dates(date);
        }
        return this.startDate(date).datesUntil(date.plusDays(1L)).collect(Collectors.toList());
    }

    public String format(LocalDate date) {
        if (this.isSingle()) {
            return this.scale.format(date);
        }
        return this.scale.format(this.startDate(date)) + " - " + this.scale.format(date);
    }

    public String timetag(LocalDate date) {
        return this.scale.timetag(date);
    }

    public boolean isSingle() {
        return this.window == 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Period period = (Period)o;
        return this.scale == period.scale && this.window == period.window;
    }

    public int hashCode() {
        return Objects.hash(this.scale.name(), this.window);
    }

    public static Period of(String value) {
        if (value.contains(":")) {
            String[] split = value.split(":");
            Scale scale = Scale.valueOf(split[0]);
            String times = split[1].trim();
            return times.equalsIgnoreCase("last") ? new Period(scale).onlyLast(true) : new Period(scale, Integer.parseInt(times));
        }
        return new Period(Scale.valueOf(value));
    }

    private boolean isLastDay(LocalDate date) {
        LocalDate endDate = this.scale.endDate(date);
        return date.compareTo(endDate) == 0 || date.compareTo(LocalDate.now()) == 0;
    }
}

