/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.helpers.Formatters;
import io.intino.sumus.reporting.helpers.MinifyHelper;
import io.intino.sumus.reporting.helpers.ResourceHelper;
import io.intino.sumus.reporting.helpers.ZipHelper;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.templates.NavigationBuilder;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.TemplateFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DashboardBuilder {
    private static final String BaseHtml = ResourceHelper.getResourceFileAsString("Common.html");
    public static final String GlobalNode = "_All";
    private final Dashboard dashboard;
    private final File folder;

    public DashboardBuilder(Dashboard dashboard, File folder) {
        this.dashboard = dashboard;
        this.folder = new File(folder, dashboard.name());
        this.folder.mkdirs();
    }

    private List<ViewBuilder> viewBuilders(LocalDate date) {
        return this.dashboard.views().stream().map(v -> this.viewBuilder((Dashboard.View)v, date)).collect(Collectors.toList());
    }

    private List<ReportBuilder> reportBuilders(LocalDate date) {
        return this.dashboard.reports().stream().map(report -> this.reportBuilder((Dashboard.Report)report, date)).collect(Collectors.toList());
    }

    private ViewBuilder viewBuilder(Dashboard.View view, LocalDate date) {
        return new ViewBuilder(view, date);
    }

    private ReportBuilder reportBuilder(Dashboard.Report report, LocalDate date) {
        return new ReportBuilder(report, date);
    }

    public synchronized void build(LocalDate date) {
        this.viewBuilders(date).forEach(builder -> builder.build(this.folder));
        this.reportBuilders(date).forEach(builder -> builder.build(this.folder));
    }

    public void build(Dashboard.View view, LocalDate date) {
        this.viewBuilder(view, date).build(this.folder);
    }

    public void build(Dashboard.Report report, LocalDate date) {
        this.reportBuilder(report, date).build(this.folder);
    }

    public String build(Dashboard.Report report, LocalDate date, Dashboard.Node node) {
        return this.reportBuilder(report, date).bodyOf(node);
    }

    private static Filter filterOf(Ledger ledger, Dashboard.Node node, String ... filterNames) {
        List<String> filters = Arrays.stream(filterNames).collect(Collectors.toList());
        if (!node.name().isEmpty()) {
            filters.add(node.filter());
        }
        return DashboardBuilder.filterOf(ledger, filters);
    }

    private static Filter filterOf(Ledger ledger, List<String> slices) {
        return SliceFilter.of(slices.stream().map(arg_0 -> ((Ledger)ledger).slice(arg_0)).collect(Collectors.toList()));
    }

    private static void save(File file, String content) {
        try {
            file.getParentFile().mkdirs();
            Files.write(file.toPath(), content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class ReportBuilder {
        public final Dashboard.Report report;
        private final Period period;
        private final LocalDate date;
        private final List<InsightBuilder> builders;
        private final NavigationBuilder navBuilder;

        public ReportBuilder(Dashboard.Report report, LocalDate date) {
            this.report = report;
            this.date = date;
            this.period = new Period(Scale.Day);
            this.navBuilder = new NavigationBuilder(report, date, this.period);
            this.builders = report.insights().stream().filter(Objects::nonNull).map(insight -> new InsightBuilder((Dashboard.Insight)insight, this.period, date)).collect(Collectors.toList());
        }

        public void build(File root) {
            File folder = this.folder(root);
            for (Dashboard.Node node : DashboardBuilder.this.dashboard.nodes()) {
                File file = new File(folder, this.filename(node));
                DashboardBuilder.save(file, this.bodyOf(node));
            }
            ZipHelper.zipAndRemove(folder);
        }

        public String bodyOf(Dashboard.Node node) {
            String template = this.template(node);
            for (InsightBuilder b : this.builders) {
                template = template.replace(b.mark(), b.bodyOf(node));
            }
            return MinifyHelper.minify(template);
        }

        public File folder(File root) {
            return new File(root, "reports/" + this.report.name() + "/" + this.period.timetag(this.date));
        }

        public String filename(Dashboard.Node node) {
            String name = node.name().isEmpty() ? DashboardBuilder.GlobalNode : node.name();
            return name + ".html";
        }

        private String template(Dashboard.Node node) {
            return DashboardBuilder.this.dashboard.template() + this.navBuilder.build(node) + BaseHtml + this.template();
        }

        private String template() {
            String template = this.report.template();
            if (template != null && !template.isEmpty()) {
                return template;
            }
            return this.builders.stream().map(InsightBuilder::mark).collect(Collectors.joining("\n"));
        }

        private class InsightBuilder {
            private final Dashboard.Insight insight;
            private final TemplateBuilder builder;
            private Ledger ledger;
            private List<Dimension> dimensions;

            public InsightBuilder(Dashboard.Insight insight, Period period, LocalDate date) {
                this.insight = insight;
                this.builder = TemplateFactory.builderOf(insight, ReportBuilder.this.report.name(), date, period);
                if (insight.ledger() == null) {
                    return;
                }
                this.ledger = DashboardBuilder.this.dashboard.ledger(insight.ledger(), period, date);
                this.dimensions = Arrays.stream(insight.dimensions()).map(arg_0 -> ((Ledger)this.ledger).dimension(arg_0)).collect(Collectors.toList());
            }

            public String mark() {
                return Formatters.translationMark(this.insight.id());
            }

            public String bodyOf(Dashboard.Node node) {
                if (!this.isVisible(node)) {
                    return "";
                }
                Cube cube = this.cube(node);
                return this.builder.build(cube, node);
            }

            private Cube cube(Dashboard.Node node) {
                if (this.ledger == null) {
                    return CubesHelper.emptyCube();
                }
                try {
                    return this.ledger.cube().dimensions(this.dimensions).filter(this.filterOf(node)).build();
                }
                catch (Throwable e) {
                    return CubesHelper.emptyCube();
                }
            }

            private Filter filterOf(Dashboard.Node node) {
                return DashboardBuilder.filterOf(this.ledger, node, this.insight.filters());
            }

            private boolean isVisible(Dashboard.Node node) {
                Dashboard.Insight.Visibility visibility = this.insight.visibility();
                if (Dashboard.Insight.Visibility.None == visibility) {
                    return false;
                }
                if (Dashboard.Insight.Visibility.Root == visibility && node.parent() == null) {
                    return true;
                }
                if (Dashboard.Insight.Visibility.Leaves == visibility && node.children().isEmpty()) {
                    return true;
                }
                if (Dashboard.Insight.Visibility.AllButLeaves == visibility && !node.children().isEmpty()) {
                    return true;
                }
                return Dashboard.Insight.Visibility.All == visibility;
            }
        }
    }

    private class ViewBuilder {
        private final Dashboard.View view;
        private final LocalDate date;
        private final Ledger ledger;
        private final List<Dimension> dimensions;

        public ViewBuilder(Dashboard.View view, LocalDate date) {
            this.view = view;
            this.date = date;
            this.ledger = DashboardBuilder.this.dashboard.ledger(view.ledger(), view.period(), date);
            this.dimensions = Arrays.stream(view.dimensions()).map(arg_0 -> ((Ledger)this.ledger).dimension(arg_0)).collect(Collectors.toList());
        }

        public void build(File root) {
            File folder = this.folder(root);
            for (Dashboard.Node node : DashboardBuilder.this.dashboard.nodes()) {
                File file = new File(folder, this.filename(node));
                DashboardBuilder.save(file, this.bodyOf(node));
            }
            ZipHelper.zipAndRemove(folder);
        }

        public String bodyOf(Dashboard.Node node) {
            Cube cube = this.cube(node);
            return TemplateFactory.builderOf(this.view).build(cube, node);
        }

        private Cube cube(Dashboard.Node node) {
            try {
                return this.ledger.cube().dimensions(this.dimensions).filter(this.filterOf(node)).build();
            }
            catch (Throwable e) {
                return CubesHelper.emptyCube();
            }
        }

        private Filter filterOf(Dashboard.Node node) {
            return DashboardBuilder.filterOf(this.ledger, node, this.view.filters());
        }

        public File folder(File root) {
            return new File(root, "views/" + this.view.name() + "/" + this.view.period().timetag(this.date));
        }

        public String filename(Dashboard.Node node) {
            String name = node.name().isEmpty() ? DashboardBuilder.GlobalNode : node.name();
            return name + ".json";
        }
    }
}

