/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.insights.TimelineInsight;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.html.Microsite;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class TimelineViewBuilder
implements TemplateBuilder {
    private final TimelineInsight insight;
    private final LocalDate date;
    private final Microsite microsite;

    public TimelineViewBuilder(Dashboard.Insight insight, LocalDate date, Microsite microsite) {
        this.insight = new TimelineInsight(insight);
        this.date = date;
        this.microsite = microsite;
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        return this.insight.type() == Dashboard.Insight.Type.EvolutionView ? this.buildEvolution(node) : (this.insight.type() == Dashboard.Insight.Type.HeatmapView ? this.buildHeatMap(node) : this.buildTable(node));
    }

    private String buildTable(Dashboard.Node node) {
        String tableID = this.insight.id() + "-table";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\"><table id=\"" + tableID + "\" class=\"timeline timeline-table\"></table>" + this.select(tableID, "_updateTimelineTable", node) + "</section>";
    }

    private String buildEvolution(Dashboard.Node node) {
        String chartID = this.insight.id() + "-chart";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\"><div id=\"" + chartID + "\" class=\"timeline timeline-evolution\"></div>" + this.select(chartID, "_updateTimelineLineChart", node) + "</section>";
    }

    private String buildHeatMap(Dashboard.Node node) {
        String chartID = this.insight.id() + "-chart";
        return "<section class=\"dashboard-section\" id=\"" + this.insight.id() + "\"><div id=\"" + chartID + "\" class=\"timeline timeline-heatmap\"></div>" + this.select(chartID, "_updateTimelineHeatmapChart", node) + "</section>";
    }

    private String select(String id, String function, Dashboard.Node node) {
        return "<select class=\"timeline\" onchange=\"" + function + "('" + id + "'," + this.config(node) + "," + this.dates() + ",'" + this.insight.label() + "', this)\"><option value=\"_All\">::All::</option></select>";
    }

    private boolean isNavigable(Dashboard.Node node) {
        return this.insight.dimensions().length == 1 && this.insight.dimensions()[0].equalsIgnoreCase(node.dimension());
    }

    private String config(Dashboard.Node node) {
        return "{report: '" + this.microsite.report() + "', ledger: '" + this.insight.ledger() + "', view: '" + this.insight.view() + "', indicator: '" + this.insight.indicator() + "', dimension: '" + this.insight.drillDimension() + "', dimension2: '" + this.insight.filterDimension() + "', nodeDimension: '" + node.dimension() + "', node: '" + node.name() + "', isNav: " + this.isNavigable(node) + "}";
    }

    private String dates() {
        Period period = this.insight.period();
        Scale scale = this.insight.timeUnit();
        List<LocalDate> dates = period.isSingle() ? this.naturalDates(period) : period.dates(this.date);
        HashSet<String> labels = new HashSet<String>();
        LinkedList<LocalDate> uniques = new LinkedList<LocalDate>();
        for (LocalDate d2 : dates) {
            if (labels.contains(scale.label(d2))) continue;
            labels.add(scale.label(d2));
            uniques.add(d2);
        }
        return "[" + uniques.stream().map(d -> "{timetag: '" + scale.timetag((LocalDate)d) + "',label: '" + scale.label((LocalDate)d) + "',format: '" + scale.format((LocalDate)d) + "',start:'" + Scale.Day.timetag(scale.startDate((LocalDate)d)) + "',end:'" + Scale.Day.timetag(scale.endDate((LocalDate)d)) + "'}").collect(Collectors.joining(",")) + "]";
    }

    private List<LocalDate> naturalDates(Period period) {
        Scale scale = period.scale();
        LocalDate start = scale.startDate(this.date);
        LocalDate end = scale.endDate(this.date);
        return start.datesUntil(end.plusDays(1L)).collect(Collectors.toList());
    }
}

