/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.insights.TableInsight;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.html.Microsite;
import io.intino.sumus.reporting.templates.html.Table;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TableBuilder
implements TemplateBuilder {
    private final TableInsight insight;
    private final Microsite microsite;

    public TableBuilder(Dashboard.Insight insight, Microsite microsite) {
        this.insight = new TableInsight(insight);
        this.microsite = microsite;
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        return new Table(this.insight.id()).title(this.insight.label()).attributes(this.attributes()).global(this.globalRow(cube, node)).rows(this.rows(cube, node)).bars(this.insight.barIndicators()).html();
    }

    private Table.Attribute[] attributes() {
        return (Table.Attribute[])Arrays.stream(this.insight.indicators()).map(Table.Attribute::new).toArray(Table.Attribute[]::new);
    }

    private Table.Row globalRow(Cube cube, Dashboard.Node node) {
        return new Table.Row(node.name()).values(this.values(cube.cell("")));
    }

    private Table.Row[] rows(Cube cube, Dashboard.Node node) {
        List<Slice> slices = this.isNavigable(node) ? this.slices(cube, node) : this.slices(cube);
        return (Table.Row[])slices.stream().map(slice -> this.row((Slice)slice, cube, node)).filter(Objects::nonNull).sorted(Table.Row.sortBy(this.insight.order(), this.insight.orderIndicator())).toArray(Table.Row[]::new);
    }

    private Table.Row row(Slice slice, Cube cube, Dashboard.Node node) {
        String name = slice.name();
        Table.Value[] values = this.values(cube.cell(name));
        if (this.areInvalid(values)) {
            return null;
        }
        return new Table.Row(name).values(values).onClick(this.action(name, node)).onMicrosite(this.micrositeAction(node, slice));
    }

    private List<Slice> slices(Cube cube, Dashboard.Node node) {
        return node.children().stream().map(Dashboard.Node::name).map(arg_0 -> ((Cube)cube).cell(arg_0)).filter(Objects::nonNull).flatMap(c -> c.slices().stream()).collect(Collectors.toList());
    }

    private List<Slice> slices(Cube cube) {
        return cube.dimensions().stream().flatMap(d -> d.slices(this.insight.level()).stream()).collect(Collectors.toList());
    }

    private boolean areInvalid(Table.Value ... values) {
        return Arrays.stream(values).allMatch(v -> v.value() == 0.0 || v.value() == null || v.value().equals(Double.NaN) || v.value().longValue() == Long.MAX_VALUE || v.value().longValue() == Long.MIN_VALUE);
    }

    private String action(String name, Dashboard.Node node) {
        return this.isNavigable(node) ? TableBuilder.openNodeAction(name) : null;
    }

    public static String openNodeAction(String name) {
        return "javascript:openNode('" + name + "')";
    }

    private String micrositeAction(Dashboard.Node node, Slice slice) {
        return this.microsite.action(node, slice);
    }

    private Table.Value[] values(Cube.Cell cell) {
        return (Table.Value[])Arrays.stream(this.insight.indicators()).map(i -> CubesHelper.indicatorOf(cell, i)).map(this::tableValue).toArray(Table.Value[]::new);
    }

    private Table.Value tableValue(Cube.Indicator indicator) {
        double value = this.parseDouble(indicator.value());
        return new Table.Value(indicator.name(), value, indicator.units());
    }

    private double parseDouble(Object object) {
        try {
            return Double.parseDouble(object.toString());
        }
        catch (Throwable e) {
            return 0.0;
        }
    }

    private boolean isNavigable(Dashboard.Node node) {
        return this.insight.dimensions().length == 1 && this.insight.dimensions()[0].equalsIgnoreCase(node.dimension());
    }
}

