/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonBuilder
implements TemplateBuilder {
    Dashboard.View view;

    public JsonBuilder(Dashboard.View view) {
        this.view = view;
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        ArrayList<CallSite> records = new ArrayList<CallSite>();
        for (Slice slice : this.slices(cube)) {
            Map<String, Double> indicatorMap;
            Cube.Cell cell = cube.cell(slice.name());
            if (this.isInvalid(cell) || this.missingDimensions(cell) || this.areAllValuesZero(indicatorMap = this.indicatorValueMap(cell))) continue;
            records.add((CallSite)((Object)("{" + this.slicesAttributes(cell) + "," + this.indicatorsAttributes(indicatorMap) + "}")));
        }
        return "[" + String.join((CharSequence)",", records) + "]";
    }

    private boolean areAllValuesZero(Map<String, Double> indicatorMap) {
        return indicatorMap.isEmpty() || indicatorMap.values().stream().allMatch(i -> i == 0.0);
    }

    private Map<String, Double> indicatorValueMap(Cube.Cell cell) {
        return cell.indicators().stream().filter(this::isAllowed).collect(Collectors.toMap(Cube.Indicator::name, i -> this.parseDouble(i.value())));
    }

    private boolean missingDimensions(Cube.Cell cell) {
        List cellDimensions = cell.slices().stream().map(s -> s.dimension().name()).collect(Collectors.toList());
        return !Arrays.stream(this.view.dimensions()).allMatch(cellDimensions::contains);
    }

    private boolean isInvalid(Cube.Cell cell) {
        return cell == null || cell.slices().isEmpty();
    }

    private boolean isAllowed(Cube.Indicator indicator) {
        return Arrays.stream(this.view.indicators()).anyMatch(i -> i.equalsIgnoreCase(indicator.name()));
    }

    private String indicatorsAttributes(Map<String, Double> indicatorMap) {
        return indicatorMap.entrySet().stream().map(e -> this.jsonString((String)e.getKey()) + ":" + e.getValue()).collect(Collectors.joining(","));
    }

    private String slicesAttributes(Cube.Cell cell) {
        return cell.slices().stream().map(s -> this.jsonString(s.dimension().name()) + ":" + this.jsonString(s.name())).collect(Collectors.joining(","));
    }

    private String jsonString(String value) {
        return "\"" + value + "\"";
    }

    private double parseDouble(Object object) {
        try {
            double v = Double.parseDouble(object.toString());
            return (double)Math.round(v * 100.0) / 100.0;
        }
        catch (Throwable e) {
            return 0.0;
        }
    }

    private List<Slice> slices(Cube cube) {
        return cube.dimensions().stream().flatMap(d -> d.slices(this.view.level()).stream()).collect(Collectors.toList());
    }
}

