/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.html.Column;
import io.intino.sumus.reporting.templates.html.Microsite;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ColumnChartBuilder
implements TemplateBuilder {
    private static final int MaxLevel = 100;
    private final Dashboard.Insight insight;
    private final Microsite microsite;

    public ColumnChartBuilder(Dashboard.Insight insight, Microsite microsite) {
        this.insight = insight;
        this.microsite = microsite;
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        Column column = new Column(this.insight.id(), this.insight.label());
        column.add(this.insight.indicators());
        for (Slice slice : this.slices(cube)) {
            Column.Serie serie;
            Cube.Cell cell = cube.cell(slice.name());
            if (cell == null || cell.toString().isEmpty() || this.isInvalid(serie = this.serie(cell))) continue;
            column.add(serie.onClick(this.onclickAction(node, cell)));
        }
        return column.html();
    }

    private List<Slice> slices(Cube cube) {
        return cube.dimensions().stream().flatMap(d -> d.slices(100).stream()).collect(Collectors.toList());
    }

    private Column.Serie serie(Cube.Cell cell) {
        Column.Serie serie = new Column.Serie(cell.toString());
        Arrays.stream(this.insight.indicators()).map(i -> CubesHelper.indicatorOf(cell, i)).mapToLong(indicator -> this.parseLong(indicator.value())).forEach(serie::add);
        return serie;
    }

    private boolean isInvalid(Column.Serie serie) {
        return serie.values().stream().allMatch(v -> v == 0L);
    }

    private long parseLong(Object object) {
        try {
            return Long.parseLong(object.toString());
        }
        catch (Throwable e) {
            return 0L;
        }
    }

    private String onclickAction(Dashboard.Node node, Cube.Cell cell) {
        return this.microsite.action(node, cell.slices());
    }
}

