/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.model;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.stream.Collectors;

public enum Scale {
    Day,
    Week,
    Month,
    Quarter,
    Year;


    public List<LocalDate> dates(LocalDate to) {
        return this.startDate(to).datesUntil(to.plusDays(1L)).collect(Collectors.toList());
    }

    public LocalDate startDate(LocalDate date) {
        if (this == Week) {
            return date.with(TemporalAdjusters.previous(DayOfWeek.MONDAY));
        }
        if (this == Month) {
            return date.withDayOfMonth(1);
        }
        if (this == Quarter) {
            return date.with(date.getMonth().firstMonthOfQuarter()).withDayOfMonth(1);
        }
        if (this == Year) {
            return date.withDayOfYear(1);
        }
        return date;
    }

    public LocalDate endDate(LocalDate date) {
        if (this == Week) {
            return date.with(TemporalAdjusters.next(DayOfWeek.SUNDAY));
        }
        if (this == Month) {
            return this.startDate(date).plusMonths(1L).minusDays(1L);
        }
        if (this == Quarter) {
            return this.startDate(date).plusMonths(2L).with(TemporalAdjusters.lastDayOfMonth());
        }
        if (this == Year) {
            return this.startDate(date).plusYears(1L).minusDays(1L);
        }
        return date;
    }

    public String format(LocalDate date) {
        if (this == Day) {
            return date.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        }
        if (this == Week) {
            return date.getYear() + "-" + date.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
        }
        if (this == Month) {
            return date.format(DateTimeFormatter.ofPattern("MM/yyyy"));
        }
        if (this == Quarter) {
            return date.format(DateTimeFormatter.ofPattern("yyyy-'Q'q"));
        }
        if (this == Year) {
            return date.format(DateTimeFormatter.ofPattern("yyyy"));
        }
        return "";
    }

    public String timetag(LocalDate date) {
        if (this == Day) {
            return date.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        if (this == Week) {
            return date.getYear() + "W" + date.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
        }
        if (this == Month) {
            return date.format(DateTimeFormatter.ofPattern("yyyyMM"));
        }
        if (this == Quarter) {
            return date.format(DateTimeFormatter.ofPattern("yyyy'Q'q"));
        }
        if (this == Year) {
            return date.format(DateTimeFormatter.ofPattern("yyyy"));
        }
        return "";
    }

    public String label(LocalDate date) {
        if (this == Day) {
            return date.format(DateTimeFormatter.ofPattern("dd"));
        }
        if (this == Week) {
            return "W" + date.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
        }
        if (this == Month) {
            return date.format(DateTimeFormatter.ofPattern("MM"));
        }
        if (this == Quarter) {
            return date.format(DateTimeFormatter.ofPattern("'Q'q"));
        }
        if (this == Year) {
            return date.format(DateTimeFormatter.ofPattern("yyyy"));
        }
        return "";
    }
}

