/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting;

import io.intino.sumus.engine.Ledger;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import java.io.File;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Dashboard {
    public String name();

    public File datamart();

    public List<Node> nodes();

    public List<Report> reports();

    public List<View> views();

    public Ledger ledger(String var1, Period var2, LocalDate var3);

    default public String template() {
        return "";
    }

    public static interface Insight {
        public String id();

        public String label();

        public Type type();

        public String ledger();

        public String[] dimensions();

        public String[] filters();

        public String[] indicators();

        public int level();

        public Map<String, String> options();

        default public Visibility visibility() {
            return Visibility.All;
        }

        default public Order order() {
            return Order.Descending;
        }

        default public String orderIndicator() {
            return null;
        }

        public static enum Order {
            Natural,
            Alphabetically,
            Descending,
            Ascending;

        }

        public static enum Visibility {
            All,
            Root,
            Leaves,
            AllButLeaves;

        }

        public static enum Type {
            Table,
            TableBar,
            Pie,
            Gauge,
            Column,
            Json,
            TimelineView,
            EvolutionView,
            HeatmapView;

        }
    }

    public static interface View {
        public String name();

        public String ledger();

        public String[] dimensions();

        public String[] filters();

        public String[] indicators();

        public int level();

        default public Period period() {
            return new Period(Scale.Day);
        }
    }

    public static interface Report {
        public String name();

        public String group();

        public String template();

        public Set<String> ledgers();

        public List<Insight> insights();

        default public Period[] periods() {
            return new Period[]{new Period(Scale.Day)};
        }
    }

    public static interface Node {
        public String name();

        public String dimension();

        public Node parent();

        public List<Node> children();

        default public String filter() {
            return this.dimension() + ":" + this.name();
        }
    }
}

