package io.intino.sumus.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class Json {

    public static String toJson(Object obj) {
        return new Gson().toJson(obj);
    }

    public static String toJsonPretty(Object obj) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(obj);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return new Gson().fromJson(json, clazz);
    }
}
