package io.intino.sumus.parser;

import org.antlr.v4.runtime.CommonTokenStream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.ParseException;

import static org.antlr.v4.runtime.CharStreams.fromString;

public class SumusParser {
	private String text;

	public SumusParser(File file) {
		try {
			this.text = Files.readString(file.toPath(), Charset.defaultCharset());
		} catch (IOException e) {
			text = "";
		}
	}

	public SumusParser(InputStream inputStream) {
		try {
			this.text = new String(inputStream.readAllBytes());
		} catch (IOException e) {
			text = "";
		}
	}

	public SumusParser(String text) {
		this.text = text;
	}

	public SumusGrammar.RootContext parse() throws ParseException {
		try {
			SumusLexer lexer = new SumusLexer(fromString(text.trim()));
			lexer.reset();
			CommonTokenStream tokens = new CommonTokenStream(lexer);
			SumusGrammar grammar = new SumusGrammar(tokens);
			grammar.setErrorHandler(new SumusErrorStrategy());
			grammar.addErrorListener(new GrammarErrorListener());
			return grammar.root();
		} catch (RuntimeException e) {
			throw new ParseException(e.getMessage(), 0);
		}
	}
}
