package io.intino.sumus.model;

import java.util.List;

import static java.util.Collections.unmodifiableList;

public class SimpleIndicatorDefinition extends IndicatorDefinition {

	private final Function function;
	private final AttributeDefinition attribute;
	private final List<String> filteredValues;

	public SimpleIndicatorDefinition(String name, Function function, AttributeDefinition attribute, String unit, Scale scale, List<String> filteredValues, Integer decimals) {
		super(name, unit, scale, decimals);
		this.function = function;
		this.attribute = attribute;
		this.filteredValues = unmodifiableList(filteredValues);
	}

	public Function function() {
		return function;
	}

	public Formula formula() {
		return new Formula(function, attribute);
	}

	public AttributeDefinition attribute() {
		return attribute;
	}

	public List<String> filteredValues() {
		return filteredValues;
	}

	public String label() {
		return function.label + "(" + attribute.name() + ")" + (filteredValues.isEmpty() ? "" : " with " + String.join(",", filteredValues));
	}

	public enum Function {
		Count("count"), Ratio("ratio"), Sum("sum"), Avg("average"), Max("max"), Min("min");
		public final String label;

		Function(String label) {
			this.label = label;
		}
	}

	public static class Formula {

		public final Function function;
		public final AttributeDefinition attribute;

		public Formula(Function function, AttributeDefinition attribute) {
			this.function = function;
			this.attribute = attribute;
		}

		@Override
		public String toString() {
			return function.label + "(" + attribute.name() + ")";
		}
	}

}
