package io.intino.sumus.model;

public abstract class IndicatorDefinition {

	private final String name;
	private final String unit;
	private final Scale scale;
	private final Integer decimals;

	public IndicatorDefinition(String name, String unit, Scale scale, Integer decimals) {
		this.name = name;
		this.unit = unit;
		this.scale = scale;
		this.decimals = decimals;
	}

	public String name() {
		return name;
	}

	public String unit() {
		return unit;
	}

	public Scale scale() {
		return scale;
	}

	public Integer decimals() {
		return decimals;
	}

	public boolean isComposite() {
		return false;
	}

	public SimpleIndicatorDefinition asSimple() {
		return (SimpleIndicatorDefinition) this;
	}

	public CompositeIndicatorDefinition asComposite() {
		return (CompositeIndicatorDefinition) this;
	}

	public abstract String label();

	@Override
	public String toString() {
		return label();
	}

	public static class Scale {
		private final double from;
		private final double to;

		public Scale(double from, double to) {
			this.from = from;
			this.to = to;
		}

		public double from() {
			return from;
		}

		public double to() {
			return to;
		}

		public double ratio() {
			return to / from;
		}
	}

}
