package io.intino.sumus.model;


public class CompositeIndicatorDefinition extends IndicatorDefinition {

    private final String formula;

    public CompositeIndicatorDefinition(String name, String formula, String unit, Scale scale, Integer decimals) {
        super(name, unit, scale, decimals);
        this.formula = formula;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public String formula() {
        return formula;
    }

    public String label() {
        return "calculate(" + formula + ")";
    }
}
