package io.intino.sumus;

import io.intino.sumus.model.CompositeIndicatorDefinition;
import io.intino.sumus.model.IndicatorDefinition.Scale;
import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.parser.SumusGrammar.DeclarationContext;
import io.intino.sumus.parser.SumusGrammar.ParameterContext;
import io.intino.sumus.parser.SumusGrammar.ValueContext;
import io.intino.sumus.util.ParseUtils;

import java.text.ParseException;
import java.util.List;

import static io.intino.sumus.util.ParseUtils.findParameterByNameOrPosition;

public class CompositeIndicatorBuilder {

	public CompositeIndicatorDefinition build(DeclarationContext i, LedgerDefinition ledger) throws ParseException {
		String name = i.name().getText();
		String formula = parseFormula(findParameterByNameOrPosition(i.parameters().parameter(), "formula", 0));
		String unit = IndicatorBuilder.parseUnit(findParameter(i.parameters().parameter(), "unit"));
		Scale scale = IndicatorBuilder.parseScale(findParameter(i.parameters().parameter(), "scale"));
		int decimals = IndicatorBuilder.parseDecimals(findParameter(i.parameters().parameter(), "decimals"));
		return new CompositeIndicatorDefinition(name, formula, unit, scale, decimals);
	}

	private static String parseFormula(ValueContext f) throws ParseException {
		if (f == null) throw new ParseException("Parameter formula not found", 0);
		return f.getText().replace("\"", "").replaceAll("\\s+", " ").trim();
	}

	private static ValueContext findParameter(List<ParameterContext> parameters, String name) {
		try {
			return ParseUtils.findParameter(parameters, name);
		} catch (ParseException ignored) {
			return null;
		}
	}
}
