/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.model;

import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.IndicatorDefinition;
import java.util.Collections;
import java.util.List;

public class SimpleIndicatorDefinition
extends IndicatorDefinition {
    private final Function function;
    private final AttributeDefinition attribute;
    private final List<String> filteredValues;

    public SimpleIndicatorDefinition(String name, Function function, AttributeDefinition attribute, String unit, IndicatorDefinition.Scale scale, List<String> filteredValues, Integer decimals) {
        super(IndicatorDefinition.Type.Simple, name, unit, scale, decimals);
        this.function = function;
        this.attribute = attribute;
        this.filteredValues = Collections.unmodifiableList(filteredValues);
    }

    public Function function() {
        return this.function;
    }

    public Formula formula() {
        return new Formula(this.function, this.attribute);
    }

    public AttributeDefinition attribute() {
        return this.attribute;
    }

    public List<String> filteredValues() {
        return this.filteredValues;
    }

    @Override
    public String label() {
        return this.function.label + "(" + this.attribute.name() + ")" + (String)(this.filteredValues.isEmpty() ? "" : " with " + String.join((CharSequence)",", this.filteredValues));
    }

    public static enum Function {
        Count("count"),
        Ratio("ratio"),
        Sum("sum"),
        Avg("average"),
        Max("max"),
        Min("min");

        public final String label;

        private Function(String label) {
            this.label = label;
        }
    }

    public static class Formula {
        public final Function function;
        public final AttributeDefinition attribute;

        public Formula(Function function, AttributeDefinition attribute) {
            this.function = function;
            this.attribute = attribute;
        }

        public String toString() {
            return this.function.label + "(" + this.attribute.name() + ")";
        }
    }
}

