/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.model;

import io.intino.sumus.engine.builders.LedgerDefinitionBuilder;
import io.intino.sumus.engine.helpers.Json;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.CompositeIndicatorDefinition;
import io.intino.sumus.engine.model.DimensionDefinition;
import io.intino.sumus.engine.model.IndicatorDefinition;
import io.intino.sumus.engine.model.SimpleIndicatorDefinition;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LedgerDefinition {
    public final Content content;
    public final Format format;
    public final List<AttributeDefinition> attributes;
    public final List<IndicatorDefinition> indicators;
    public final List<DimensionDefinition> dimensions;
    public Aggregation aggregation;
    public String label;
    public String description;

    public static LedgerDefinition load(File baseDir, File definitionFile) throws ParseException {
        return new LedgerDefinitionBuilder(baseDir).build(definitionFile);
    }

    public static LedgerDefinition load(File baseDir, String definition) throws ParseException {
        return new LedgerDefinitionBuilder(baseDir).build(definition);
    }

    public LedgerDefinition(Content content, Format format) {
        this.content = content;
        this.format = format;
        this.attributes = new ArrayList<AttributeDefinition>();
        this.indicators = new ArrayList<IndicatorDefinition>();
        this.dimensions = new ArrayList<DimensionDefinition>();
    }

    public LedgerDefinition(Content content, Format format, Aggregation aggregation, String label, String description) {
        this(content, format);
        this.aggregation = aggregation;
        this.label = label;
        this.description = description;
    }

    public void add(AttributeDefinition attr) {
        this.attributes.add(attr);
    }

    public void add(IndicatorDefinition indicator) {
        this.indicators.add(indicator);
    }

    public void add(DimensionDefinition dimension) {
        this.dimensions.add(dimension);
    }

    public AttributeDefinition attribute(String name) {
        return this.attributes.stream().filter(a -> a.name().equals(name)).findFirst().orElse(null);
    }

    public IndicatorDefinition indicator(String name) {
        return this.indicators.stream().filter(a -> a.name().equals(name)).findFirst().orElse(null);
    }

    public List<SimpleIndicatorDefinition> simpleIndicators() {
        return this.indicators.stream().filter(i -> !i.isComposite()).map(IndicatorDefinition::asSimple).collect(Collectors.toList());
    }

    public List<CompositeIndicatorDefinition> compositeIndicators() {
        return this.indicators.stream().filter(IndicatorDefinition::isComposite).map(IndicatorDefinition::asComposite).collect(Collectors.toList());
    }

    public String toString() {
        return Json.toJsonPretty(this);
    }

    public static enum Content {
        Events,
        Status,
        Master;

    }

    public static enum Format {
        Binary,
        Tsv;

    }

    public static class Aggregation {
        public Period period;
        public String ledger;
        public String recordKey;
        public String from;

        public Aggregation(Period period, String ledger, String recordKey, String from) {
            this.period = period;
            this.ledger = ledger;
            this.recordKey = recordKey;
            this.from = from;
        }

        public static enum Period {
            Week,
            Month,
            Quarter,
            Year;

        }
    }
}

