/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.model;

import io.intino.sumus.engine.model.CompositeIndicatorDefinition;
import io.intino.sumus.engine.model.SimpleIndicatorDefinition;

public abstract class IndicatorDefinition {
    private final Type type;
    private final String name;
    private final String unit;
    private final Scale scale;
    private final Integer decimals;

    public IndicatorDefinition(Type type, String name, String unit, Scale scale, Integer decimals) {
        this.type = type;
        this.name = name;
        this.unit = unit;
        this.scale = scale;
        this.decimals = decimals;
    }

    public String name() {
        return this.name;
    }

    public String unit() {
        return this.unit;
    }

    public Scale scale() {
        return this.scale;
    }

    public Integer decimals() {
        return this.decimals;
    }

    public boolean isComposite() {
        return this.type == Type.Composite;
    }

    public SimpleIndicatorDefinition asSimple() {
        return (SimpleIndicatorDefinition)this;
    }

    public CompositeIndicatorDefinition asComposite() {
        return (CompositeIndicatorDefinition)this;
    }

    public abstract String label();

    public String toString() {
        return this.label();
    }

    public static enum Type {
        Simple,
        Composite;

    }

    public static class Scale {
        private final double from;
        private final double to;

        public Scale(double from, double to) {
            this.from = from;
            this.to = to;
        }

        public double from() {
            return this.from;
        }

        public double to() {
            return this.to;
        }

        public double ratio() {
            return this.to / this.from;
        }
    }
}

