/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.model;

import io.intino.sumus.engine.helpers.Json;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.Classifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public abstract class DimensionDefinition
implements Serializable {
    private final Type type;
    private final String name;
    private final AttributeDefinition attribute;
    private final Map<String, Predicate<?>> categories;
    private Map<String, String> categoryValue = new HashMap<String, String>();

    public DimensionDefinition(Type type, String name, AttributeDefinition attribute, Map<String, Predicate<?>> categories) {
        this.type = type;
        this.name = name;
        this.attribute = attribute;
        this.categories = Collections.unmodifiableMap(categories);
    }

    public DimensionDefinition categoryRange(Map<String, String> categoryRange) {
        this.categoryValue = categoryRange;
        return this;
    }

    public AttributeDefinition attribute() {
        return this.attribute;
    }

    public String name() {
        return this.name;
    }

    public Classifier classifier() {
        return new Classifier(){

            @Override
            public List<String> categories() {
                return new ArrayList<String>(DimensionDefinition.this.categories.keySet());
            }

            @Override
            public <T> Predicate<T> predicateOf(String category) {
                return DimensionDefinition.this.categories.get(category);
            }

            @Override
            public boolean classify(String category, Object value) {
                return this.predicateOf(category).test(value);
            }
        };
    }

    public boolean isNumeric() {
        return this.type == Type.Numerical;
    }

    public Map<String, Predicate<?>> categories() {
        return this.categories;
    }

    public String toString() {
        return Json.toJsonPretty(this);
    }

    public static enum Type {
        Numerical,
        Categorical;

    }

    public static class Categorical
    extends DimensionDefinition {
        public Categorical(String name, AttributeDefinition attribute, Map<String, Predicate<?>> categories) {
            super(Type.Categorical, name, attribute, categories);
        }
    }

    public static class Numerical
    extends DimensionDefinition {
        public Numerical(String name, AttributeDefinition attribute, Map<String, Predicate<?>> categories) {
            super(Type.Numerical, name, attribute, categories);
        }
    }
}

