/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.ledgers.composite;

import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Index;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.ledgers.composite.CompositeIndex;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CompositeSlice
implements Slice {
    private final Slice prototype;
    private final List<Slice> slices;
    private final int[] offsets;
    private final Slice parent;
    private Index index;

    public CompositeSlice(List<Slice> slices, int[] offsets, Slice parent) {
        this.prototype = slices.stream().filter(Objects::nonNull).findFirst().orElse(null);
        this.slices = slices;
        this.offsets = offsets;
        this.index = null;
        this.parent = parent;
    }

    @Override
    public String name() {
        return this.prototype.name();
    }

    @Override
    public Slice parent() {
        return this.parent;
    }

    @Override
    public Dimension dimension() {
        return this.prototype.dimension();
    }

    @Override
    public boolean isNA() {
        for (Slice slice : this.slices) {
            if (slice == null || !slice.isNA()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Index index() {
        if (this.index == null) {
            this.index = new CompositeIndex(this.indexes(), this.offsets);
        }
        return this.index;
    }

    private List<Index> indexes() {
        return this.slices.stream().map(s -> s != null ? s.index() : Index.None).collect(Collectors.toList());
    }

    public String toString() {
        return this.name();
    }
}

