/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.ledgers.composite;

import io.intino.sumus.engine.Index;
import java.util.List;
import java.util.stream.Collectors;

public class CompositeIndex
implements Index {
    private final List<Index> indexes;
    private final int[] offsets;

    public CompositeIndex(List<Index> indexes, int[] offsets) {
        this.indexes = indexes.stream().map(this::wrap).collect(Collectors.toList());
        this.offsets = offsets;
    }

    @Override
    public boolean accepts(int idx) {
        int pos = this.posOf(idx);
        return this.indexes.get(pos).accepts(idx - this.offsets[pos]);
    }

    private int posOf(int idx) {
        int pos = this.offsets.length - 1;
        while (idx < this.offsets[pos]) {
            --pos;
        }
        return pos;
    }

    private Index wrap(Index i) {
        return i != null ? i : Index.None;
    }
}

