/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.filters;

import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Index;
import io.intino.sumus.engine.Slice;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SliceFilter
implements Filter {
    private final Set<Slice> slices;
    private final Set<Dimension> dimensions;
    private final Index index;

    public static Filter of(Slice ... slices) {
        return SliceFilter.of(Arrays.asList(slices));
    }

    public static Filter of(List<Slice> slices) {
        if (slices.isEmpty()) {
            return None;
        }
        if (SliceFilter.anyIsNull(slices)) {
            return All;
        }
        return new SliceFilter(slices);
    }

    private SliceFilter(List<Slice> slices) {
        this.slices = new HashSet<Slice>(slices);
        this.dimensions = slices.stream().map(Slice::dimension).collect(Collectors.toSet());
        this.index = new Slice.SliceIndex(this.slices);
    }

    @Override
    public boolean accepts(int idx) {
        return this.index.accepts(idx);
    }

    @Override
    public List<? extends Slice> crop(List<? extends Slice> slices) {
        return slices.stream().filter(this::accepts).collect(Collectors.toList());
    }

    private boolean accepts(Slice slice) {
        return !this.dimensions.contains(slice.dimension()) || this.contains(slice);
    }

    private boolean contains(Slice slice) {
        return slice != null && (this.slices.contains(slice) || this.contains(slice.parent()));
    }

    public String toString() {
        return this.slices.stream().map(Slice::name).collect(Collectors.joining(" | "));
    }

    private static boolean anyIsNull(List<Slice> slices) {
        return slices.stream().anyMatch(Objects::isNull);
    }
}

