/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.dimensions;

import io.intino.sumus.engine.Lookup;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.SumusException;
import io.intino.sumus.engine.dimensions.AbstractDimension;
import io.intino.sumus.engine.model.AttributeDefinition;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

public class DayDimension
extends AbstractDimension {
    public DayDimension(Lookup lookup) {
        super(lookup);
        this.slices.addAll(this.buildSlices());
        if (lookup.hasNA()) {
            this.slices.add(new AbstractDimension.DimensionSlice());
        }
    }

    private List<Slice> buildSlices() {
        return this.days().boxed().map(this::slice).collect(Collectors.toList());
    }

    @Override
    public String name() {
        return this.lookup.name() + "-day";
    }

    @Override
    protected void check() {
        if (this.lookup.type() == AttributeDefinition.Type.date) {
            return;
        }
        throw new SumusException("Day dimension must use a date column");
    }

    private Slice slice(long epoch) {
        LocalDate date = LocalDate.ofEpochDay(epoch);
        return new AbstractDimension.DimensionSlice(date.toString(), v -> this.match(epoch, v));
    }

    private boolean match(long epoch, Object value) {
        return value instanceof Long && epoch == (Long)value;
    }

    private LongStream days() {
        try {
            long min = (Long)this.lookup.min();
            long max = (Long)this.lookup.max();
            return LongStream.range(min, max + 1L);
        }
        catch (Exception e) {
            return LongStream.empty();
        }
    }
}

