/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.dimensions;

import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Index;
import io.intino.sumus.engine.Lookup;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.model.AttributeDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public abstract class AbstractDimension
implements Dimension,
Iterable<Slice> {
    public final Lookup lookup;
    public final List<Slice> slices;

    public AbstractDimension(Lookup lookup) {
        this.lookup = lookup;
        this.slices = new ArrayList<Slice>();
        this.check();
    }

    protected abstract void check();

    @Override
    public String name() {
        return this.lookup.name();
    }

    @Override
    public AttributeDefinition.Type type() {
        return this.lookup.type();
    }

    @Override
    public List<? extends Slice> slices() {
        return this.slices;
    }

    @Override
    public boolean hasNA() {
        for (Slice slice : this.slices) {
            if (!slice.isNA()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Slice> iterator() {
        return this.slices.iterator();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(this.name());
    }

    public String toString() {
        return this.name();
    }

    protected class DimensionSlice
    implements Slice {
        public final String name;
        public final DimensionSlice parent;
        private final Predicate<Object> predicate;
        private final Index index;

        public DimensionSlice(String name, Predicate<Object> predicate) {
            this(name, predicate, null);
        }

        public DimensionSlice(String name, Predicate<Object> predicate, DimensionSlice parent) {
            this.name = name;
            this.predicate = predicate;
            this.parent = parent;
            this.index = AbstractDimension.this.lookup.createIndex(predicate);
        }

        public DimensionSlice() {
            this.name = "NA";
            this.predicate = Objects::isNull;
            this.parent = null;
            this.index = AbstractDimension.this.lookup.createIndex(this.predicate);
        }

        @Override
        public Slice parent() {
            return this.parent;
        }

        @Override
        public Dimension dimension() {
            return AbstractDimension.this;
        }

        @Override
        public Index index() {
            return this.index;
        }

        @Override
        public int level() {
            return this.parent == null ? 1 : this.parent.level() + 1;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean isNA() {
            return this.name.equals("NA");
        }

        public String toString() {
            return this.name;
        }
    }
}

