/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.deserializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import io.intino.sumus.engine.builders.deserializers.DimensionDefinitionDeserializer;
import io.intino.sumus.engine.builders.deserializers.IndicatorDefinitionDeserializer;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.DimensionDefinition;
import io.intino.sumus.engine.model.IndicatorDefinition;
import io.intino.sumus.engine.model.LedgerDefinition;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LedgerDefinitionDeserializer
implements JsonDeserializer<LedgerDefinition> {
    static final Type AttributeListType = new TypeToken<List<AttributeDefinition>>(){}.getType();

    public LedgerDefinition deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext c) throws JsonParseException {
        JsonObject object = jsonElement.getAsJsonObject();
        LedgerDefinition definition = LedgerDefinitionDeserializer.baseLedgerDefinition(c, object);
        List attributes = (List)c.deserialize(object.get("attributes"), AttributeListType);
        Map<String, AttributeDefinition> attributesMap = LedgerDefinitionDeserializer.toMap(attributes);
        attributes.forEach(definition::add);
        LedgerDefinitionDeserializer.indicatorsOf(object, c, attributesMap).forEach(definition::add);
        LedgerDefinitionDeserializer.dimensionsOf(object, c, attributesMap).forEach(definition::add);
        return definition;
    }

    private static LedgerDefinition baseLedgerDefinition(JsonDeserializationContext c, JsonObject object) {
        LedgerDefinition.Content content = (LedgerDefinition.Content)((Object)c.deserialize(object.get("content"), LedgerDefinition.Content.class));
        LedgerDefinition.Format format = (LedgerDefinition.Format)((Object)c.deserialize(object.get("format"), LedgerDefinition.Format.class));
        LedgerDefinition.Aggregation aggregation = (LedgerDefinition.Aggregation)c.deserialize(object.get("aggregation"), LedgerDefinition.Aggregation.class);
        String label = (String)c.deserialize(object.get("label"), String.class);
        String description = (String)c.deserialize(object.get("description"), String.class);
        return new LedgerDefinition(content, format, aggregation, label, description);
    }

    private static List<IndicatorDefinition> indicatorsOf(JsonObject object, JsonDeserializationContext c, Map<String, AttributeDefinition> attributesMap) {
        ArrayList<IndicatorDefinition> indicators = new ArrayList<IndicatorDefinition>();
        IndicatorDefinitionDeserializer deserializer = new IndicatorDefinitionDeserializer(attributesMap);
        for (JsonElement jsonIndicator : object.getAsJsonArray("indicators")) {
            IndicatorDefinition indicator = deserializer.deserialize(jsonIndicator, (Type)((Object)IndicatorDefinition.class), c);
            indicators.add(indicator);
        }
        return indicators;
    }

    private static List<DimensionDefinition> dimensionsOf(JsonObject object, JsonDeserializationContext c, Map<String, AttributeDefinition> attributesMap) {
        ArrayList<DimensionDefinition> dimensions = new ArrayList<DimensionDefinition>();
        DimensionDefinitionDeserializer deserializer = new DimensionDefinitionDeserializer(attributesMap);
        for (JsonElement jsonIndicator : object.getAsJsonArray("dimensions")) {
            DimensionDefinition dimension = deserializer.deserialize(jsonIndicator, (Type)((Object)DimensionDefinition.class), c);
            dimensions.add(dimension);
        }
        return dimensions;
    }

    private static Map<String, AttributeDefinition> toMap(List<AttributeDefinition> attributes) {
        return attributes.stream().collect(Collectors.toMap(AttributeDefinition::name, a -> a, (a, b) -> a));
    }
}

