/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.adapters;

import io.intino.sumus.engine.builders.adapters.AttributeDefinitionAdapter;
import io.intino.sumus.engine.builders.adapters.DimensionDefinitionAdapter;
import io.intino.sumus.engine.builders.adapters.IndicatorDefinitionAdapter;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.LedgerDefinition;
import io.intino.sumus.model.LedgerDefinition;
import java.util.List;

public class LedgerDefinitionAdapter {
    public static LedgerDefinition adapt(io.intino.sumus.model.LedgerDefinition old) {
        LedgerDefinition newDefinition = new LedgerDefinition(LedgerDefinitionAdapter.content(old.content), LedgerDefinitionAdapter.format(old.format), LedgerDefinitionAdapter.aggregation(old.aggregation), old.label, old.description);
        List<AttributeDefinition> attributes = AttributeDefinitionAdapter.adapt(old.attributes);
        attributes.forEach(newDefinition::add);
        IndicatorDefinitionAdapter.adapt(old.indicators, attributes).forEach(newDefinition::add);
        DimensionDefinitionAdapter.adapt(old.dimensions, attributes).forEach(newDefinition::add);
        return newDefinition;
    }

    private static LedgerDefinition.Aggregation aggregation(LedgerDefinition.Aggregation old) {
        return old != null ? new LedgerDefinition.Aggregation(LedgerDefinitionAdapter.period(old.period), old.ledger, old.recordKey, old.from) : null;
    }

    private static LedgerDefinition.Content content(LedgerDefinition.Content old) {
        try {
            return LedgerDefinition.Content.valueOf(old.name());
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static LedgerDefinition.Format format(LedgerDefinition.Format old) {
        try {
            return LedgerDefinition.Format.valueOf(old.name());
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static LedgerDefinition.Aggregation.Period period(LedgerDefinition.Aggregation.Period old) {
        try {
            return LedgerDefinition.Aggregation.Period.valueOf(old.name());
        }
        catch (Throwable e) {
            return null;
        }
    }
}

