/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.accumulators.BuilderAccumulator;
import java.util.Arrays;
import java.util.List;

public class IntegerAccumulator
extends BuilderAccumulator {
    private final int[] count;
    private final long[] sum;
    private final long[] totalSum;
    private final long[] min;
    private final long[] max;

    public IntegerAccumulator(String name) {
        super(name);
        this.count = new int[this.threadCount];
        this.sum = new long[this.threadCount];
        this.totalSum = new long[this.threadCount];
        this.min = new long[this.threadCount];
        this.max = new long[this.threadCount];
        Arrays.fill(this.min, Long.MAX_VALUE);
        Arrays.fill(this.max, Long.MIN_VALUE);
    }

    @Override
    public void addTotal(Object value) {
        int t;
        int n = t = this.threadIndex();
        this.total[n] = this.total[n] + 1;
        if (value != null) {
            int n2 = t;
            this.totalSum[n2] = this.totalSum[n2] + (Long)value;
        }
    }

    @Override
    public void add(Object value) {
        if (value == null) {
            return;
        }
        int t = this.threadIndex();
        long v = (Long)value;
        int n = t;
        this.count[n] = this.count[n] + 1;
        int n2 = t;
        this.sum[n2] = this.sum[n2] + v;
        this.min[t] = Math.min(this.min[t], v);
        this.max[t] = Math.max(this.max[t], v);
    }

    @Override
    public List<Cube.Indicator> indicators() {
        int count = this.count();
        long totalSum = this.totalSum();
        long sum = this.sum();
        long min = this.min();
        long max = this.max();
        return List.of(Cube.indicator("count(" + this.name + ")", count), Cube.indicator("ratio(" + this.name + ")", totalSum > 0L ? (double)sum / (double)totalSum : 0.0), Cube.indicator("sum(" + this.name + ")", sum), Cube.indicator("average(" + this.name + ")", count > 0 ? (double)sum / (double)count : 0.0), Cube.indicator("min(" + this.name + ")", min), Cube.indicator("max(" + this.name + ")", max));
    }

    public long max() {
        return Arrays.stream(this.max).max().orElse(Long.MIN_VALUE);
    }

    public long min() {
        return Arrays.stream(this.min).min().orElse(Long.MAX_VALUE);
    }

    public long sum() {
        return Arrays.stream(this.sum).sum();
    }

    public long totalSum() {
        return Arrays.stream(this.totalSum).sum();
    }

    public int count() {
        return Arrays.stream(this.count).sum();
    }
}

