/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.SumusEngine;
import io.intino.sumus.engine.builders.Accumulator;
import io.intino.sumus.engine.builders.CellBuilder;
import io.intino.sumus.engine.builders.accumulators.CountAccumulator;
import io.intino.sumus.engine.builders.accumulators.DateAccumulator;
import io.intino.sumus.engine.builders.accumulators.DoubleAccumulator;
import io.intino.sumus.engine.builders.accumulators.IntegerAccumulator;
import io.intino.sumus.engine.builders.accumulators.TimeAccumulator;
import io.intino.sumus.engine.concurrency.SumusThreadFactory;
import io.intino.sumus.engine.filters.CompositeFilter;
import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.engine.helpers.IgnoreCaseMap;
import io.intino.sumus.engine.model.LedgerDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class CubeBuilder {
    private final Ledger ledger;
    private final LedgerDefinition definition;
    private final Filter filter;
    private final List<Dimension> dimensions;

    public CubeBuilder(Ledger ledger, Filter filter, Dimension ... dimensions) {
        this(ledger, filter, Arrays.asList(dimensions));
    }

    public CubeBuilder(Ledger ledger, Filter filter, List<Dimension> dimensions) {
        this.ledger = ledger;
        this.definition = ledger.definition();
        this.filter = filter;
        this.dimensions = dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cube build() {
        Class<CubeBuilder> clazz = CubeBuilder.class;
        synchronized (CubeBuilder.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cubeOf(this.executeQuery());
        }
    }

    private CellBuilder[] executeQuery() {
        return this.filter == Filter.All ? new CellBuilder[]{} : this.fill(this.withAccumulators(this.builders()));
    }

    private CellBuilder[] withAccumulators(CellBuilder[] builders) {
        for (CellBuilder builder : builders) {
            this.createAccumulators(builder);
        }
        return builders;
    }

    private CellBuilder[] fill(CellBuilder[] builders) {
        return SumusEngine.threadCount() > 1 ? this.fillMultithreading(builders) : this.fillSingleThread(builders);
    }

    private void fill(CellBuilder[] builders, Fact fact) {
        for (CellBuilder builder : builders) {
            builder.add(fact);
        }
    }

    private CellBuilder[] fillSingleThread(CellBuilder[] builders) {
        ExecutorService threadPool = Executors.newSingleThreadExecutor(new SumusThreadFactory("CubeBuilder-T"));
        threadPool.execute(() -> {
            for (Fact fact : this.ledger.facts(this.filter)) {
                this.fill(builders, fact);
            }
        });
        this.waitFor(threadPool);
        return builders;
    }

    private CellBuilder[] fillMultithreading(CellBuilder[] builders) {
        ExecutorService threadPool = SumusEngine.createThreadPool();
        List<Throwable> errors = Collections.synchronizedList(new ArrayList());
        for (Fact fact : this.ledger.facts(this.filter)) {
            threadPool.execute(() -> {
                try {
                    this.fill(builders, fact);
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            });
        }
        this.waitFor(threadPool);
        if (!errors.isEmpty()) {
            CubeBuilder.rethrowFirst(errors);
        }
        return builders;
    }

    private void waitFor(ExecutorService threadPool) {
        try {
            threadPool.shutdown();
            threadPool.awaitTermination(SumusEngine.TIMEOUT_AMOUNT.get(), SumusEngine.TIMEOUT_UNIT.get());
        }
        catch (Throwable e) {
            throw new CubeBuilderException(e);
        }
    }

    private static void rethrowFirst(List<Throwable> errors) {
        Throwable e = errors.get(0);
        throw new CubeBuilderException("Error while executing CubeBuilder: " + e.getMessage(), e);
    }

    private void createAccumulators(CellBuilder builder) {
        builder.setAccumulators((Accumulator[])this.ledger.attributes().stream().filter(Attribute::isUsedInIndicators).map(this::accumulatorOf).toArray(Accumulator[]::new));
    }

    private Accumulator accumulatorOf(Attribute attribute) {
        if (attribute.type().isInteger()) {
            return new IntegerAccumulator(attribute.name());
        }
        if (attribute.type().isReal()) {
            return new DoubleAccumulator(attribute.name());
        }
        if (attribute.type().isDate()) {
            return new DateAccumulator(attribute.name());
        }
        if (attribute.type().isTime()) {
            return new TimeAccumulator(attribute.name());
        }
        return new CountAccumulator(attribute.name());
    }

    private Cube cubeOf(CellBuilder[] builders) {
        return new CubeImpl(builders);
    }

    public CellBuilder[] builders() {
        int size = this.dimensions.size();
        List<Slice> slices = Collections.emptyList();
        ArrayList<CellBuilder> result = new ArrayList<CellBuilder>(size * size);
        for (int i = 0; i < size; ++i) {
            result.addAll(this.builders(slices, this.dimensions.subList(i, size)));
        }
        result.add(new CellBuilder(this.definition.indicators));
        return (CellBuilder[])result.toArray(CellBuilder[]::new);
    }

    private List<CellBuilder> builders(List<Slice> slices, List<Dimension> dimensions) {
        List<CellBuilder> result = this.export(slices);
        if (dimensions.isEmpty()) {
            return result;
        }
        List<? extends Slice> head = this.filter.crop(dimensions.get(0).slices());
        List<Dimension> tail = dimensions.subList(1, dimensions.size());
        for (Slice slice : head) {
            List<CellBuilder> cells = this.builders(this.join(slices, slice), tail);
            result.addAll(cells);
        }
        return result;
    }

    private List<CellBuilder> export(List<Slice> slices) {
        List result = slices.isEmpty() ? List.of() : List.of(new CellBuilder(this.definition.indicators, slices));
        return new ArrayList<CellBuilder>(result);
    }

    private List<Slice> join(List<Slice> slices, Slice slice) {
        ArrayList<Slice> result = new ArrayList<Slice>(slices);
        result.add(slice);
        return result;
    }

    public static class CubeBuilderException
    extends RuntimeException {
        public CubeBuilderException() {
        }

        public CubeBuilderException(String message) {
            super(message);
        }

        public CubeBuilderException(String message, Throwable cause) {
            super(message, cause);
        }

        public CubeBuilderException(Throwable cause) {
            super(cause);
        }
    }

    public class CubeImpl
    implements Cube {
        public final Map<String, Cube.Cell> cells;
        public final CellBuilder[] builders;

        public CubeImpl(CellBuilder[] builders) {
            this.builders = builders;
            this.cells = this.buildCells(builders);
        }

        @Override
        public List<? extends Dimension> dimensions() {
            return CubeBuilder.this.dimensions;
        }

        @Override
        public List<? extends Cube.Cell> cells() {
            return new ArrayList<Cube.Cell>(this.cells.values());
        }

        @Override
        public Map<String, ? extends Cube.Cell> cellMap() {
            return this.cells;
        }

        @Override
        public Iterable<Fact> facts(Filter filter) {
            Filter local = CompositeFilter.of(CubeBuilder.this.filter, filter);
            return local == Filter.All ? Collections.emptyList() : CubeBuilder.this.ledger.facts(local);
        }

        private Map<String, Cube.Cell> buildCells(CellBuilder[] builders) {
            return Arrays.stream(builders).map(b -> b.cell(this.facts(CompositeFilter.of(CubeBuilder.this.filter, SliceFilter.of(b.slices()))))).collect(Collectors.toMap(Object::toString, c -> c, (a, b) -> b, IgnoreCaseMap::new));
        }
    }
}

