/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.DimensionDefinition;
import io.intino.sumus.engine.model.LedgerDefinition;
import java.util.Objects;

public abstract class AbstractAttribute
implements Attribute {
    protected final AttributeDefinition definition;

    public AbstractAttribute(AttributeDefinition definition) {
        this.definition = definition;
    }

    @Override
    public AttributeDefinition definition() {
        return this.definition;
    }

    protected abstract LedgerDefinition ledgerDefinition();

    @Override
    public boolean isUsedInIndicators() {
        return this.ledgerDefinition().simpleIndicators().stream().anyMatch(i -> this.attributeMatches(i.attribute()));
    }

    @Override
    public DimensionDefinition[] dimensions() {
        return (DimensionDefinition[])this.ledgerDefinition().dimensions.stream().filter(d -> this.attributeMatches(d.attribute())).toArray(DimensionDefinition[]::new);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this == o || this.areEquals((Attribute)o);
    }

    private boolean areEquals(Attribute attribute) {
        return Objects.equals(this.name(), attribute.name()) && this.type().equals((Object)attribute.type());
    }

    private boolean attributeMatches(AttributeDefinition attribute) {
        return attribute != null && attribute.equals(this.definition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name(), this.type()});
    }

    public String toString() {
        return this.name();
    }
}

