/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;
import org.xerial.snappy.SnappyInputStream;

public class TsvLedgerReader {
    public static String[][] read(File file, String separator) throws IOException {
        if (file.getName().endsWith(".tsv")) {
            return TsvLedgerReader.readUncompressedTsv(file, separator);
        }
        if (file.getName().endsWith(".sz")) {
            return TsvLedgerReader.readSnappyTsv(file, separator);
        }
        if (file.getName().endsWith(".zip")) {
            return TsvLedgerReader.readZipTsv(file, separator);
        }
        return TsvLedgerReader.readUncompressedTsv(file, separator);
    }

    private static String[][] readZipTsv(File file, String separator) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(file));){
            String[][] stringArray = TsvLedgerReader.parseTsvLines(separator, TsvLedgerReader.linesFrom(TsvLedgerReader.readZipTsv(zis)));
            return stringArray;
        }
    }

    private static Stream<String> linesFrom(byte[] uncompressed) {
        return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(uncompressed))).lines();
    }

    private static byte[] readZipTsv(ZipInputStream zis) throws IOException {
        int read;
        zis.getNextEntry();
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(buffer.length);
        while ((read = zis.read(buffer)) > 0) {
            outputStream.write(buffer, 0, read);
        }
        return outputStream.toByteArray();
    }

    private static String[][] readSnappyTsv(File file, String separator) throws IOException {
        String[][] stringArray;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new SnappyInputStream((InputStream)new FileInputStream(file))));
        try {
            stringArray = TsvLedgerReader.parseTsvLines(separator, reader.lines());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException("File is not a valid (snappy) compressed file", e);
            }
        }
        reader.close();
        return stringArray;
    }

    private static String[][] readUncompressedTsv(File file, String separator) throws IOException {
        try (Stream<String> lines = Files.lines(file.toPath());){
            String[][] stringArray = TsvLedgerReader.parseTsvLines(separator, lines);
            return stringArray;
        }
    }

    private static String[][] parseTsvLines(String separator, Stream<String> lines) {
        return (String[][])lines.map(l -> l.split(separator)).toArray(x$0 -> new String[x$0][]);
    }
}

