/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.evaluators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.evaluators.ExpressionEvaluator;
import io.intino.sumus.model.CompositeIndicatorDefinition;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CompositeEvaluator {
    static final String TextRegex = ".*[a-zA-Z_].*";

    public static Double evaluate(CompositeIndicatorDefinition composite, List<Cube.Indicator> indicators) {
        try {
            String expression = CompositeEvaluator.expressionOf(composite.formula(), indicators);
            return ExpressionEvaluator.evaluate(expression);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static String expressionOf(String formula, List<Cube.Indicator> indicators) throws IllegalArgumentException {
        List sorted = indicators.stream().filter(Objects::nonNull).filter(i -> formula.contains(i.name())).sorted((i1, i2) -> Integer.compare(i2.name().length(), i1.name().length())).collect(Collectors.toList());
        String expression = formula;
        for (Cube.Indicator i3 : sorted) {
            Double value = CompositeEvaluator.toDouble(i3.value());
            if (value == null) continue;
            expression = expression.replace(i3.name(), new BigDecimal(value).toPlainString());
        }
        if (expression.matches(TextRegex)) {
            throw new IllegalArgumentException("Invalid formula: indicators not found");
        }
        return expression;
    }

    private static Double toDouble(Object value) {
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Throwable e) {
            return null;
        }
    }
}

