/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.dimensions;

import io.intino.sumus.engine.Lookup;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.SumusException;
import io.intino.sumus.engine.dimensions.AbstractDimension;
import io.intino.sumus.model.AttributeDefinition;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DayOfWeekDimension
extends AbstractDimension {
    public DayOfWeekDimension(Lookup lookup) {
        super(lookup);
        this.slices.addAll(this.buildSlices());
        if (lookup.hasNA()) {
            this.slices.add(new AbstractDimension.DimensionSlice());
        }
    }

    @Override
    public String name() {
        return this.lookup.name() + "-day-of-week";
    }

    private List<Slice> buildSlices() {
        return Arrays.stream(DayOfWeek.values()).map(this::sliceOf).collect(Collectors.toList());
    }

    @Override
    protected void check() {
        if (this.lookup.type() == AttributeDefinition.Type.date) {
            return;
        }
        throw new SumusException("DayOfWeek dimension must use a date column");
    }

    private Slice sliceOf(DayOfWeek dayOfWeek) {
        return new AbstractDimension.DimensionSlice(dayOfWeek.name().toLowerCase(), v -> this.match(dayOfWeek, v));
    }

    private boolean match(DayOfWeek dayOfWeek, Object value) {
        return value instanceof Long && LocalDate.ofEpochDay((Long)value).getDayOfWeek() == dayOfWeek;
    }
}

