/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.model.CompositeIndicatorDefinition;

public class CompositeCalculator {
    public static Object calculate(CompositeIndicatorDefinition definition, Cube.Indicator i1, Cube.Indicator i2) {
        return CompositeCalculator.calculate(definition.operator(), i1, i2);
    }

    public static Object calculate(CompositeIndicatorDefinition.Operator operator, Cube.Indicator i1, Cube.Indicator i2) {
        if (i1 == null || i2 == null) {
            return null;
        }
        return CompositeCalculator.calculate(operator, i1.value(), i2.value());
    }

    private static Object calculate(CompositeIndicatorDefinition.Operator operator, Object rawV1, Object rawV2) {
        Double v1 = CompositeCalculator.parseDouble(rawV1);
        Double v2 = CompositeCalculator.parseDouble(rawV2);
        if (v1 == null || v2 == null) {
            return null;
        }
        Double result = 0.0;
        switch (operator) {
            case Sum: {
                result = v1 + v2;
                break;
            }
            case Sub: {
                result = v1 - v2;
                break;
            }
            case Multiply: {
                result = v1 * v2;
                break;
            }
            case Divide: {
                result = v2 != 0.0 ? v1 / v2 : 0.0;
            }
        }
        return rawV1 instanceof Double || rawV2 instanceof Double ? result : (double)Long.valueOf(result.longValue()).longValue();
    }

    private static Double parseDouble(Object value) {
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Throwable e) {
            return null;
        }
    }
}

