/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.builders.Accumulator;
import io.intino.sumus.engine.builders.CompositeCalculator;
import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.model.CompositeIndicatorDefinition;
import io.intino.sumus.model.IndicatorDefinition;
import io.intino.sumus.model.SimpleIndicatorDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CellBuilder {
    private final List<IndicatorDefinition> indicators;
    private final Filter filter;
    private final List<Slice> slices;
    private Accumulator[] accumulators = new Accumulator[0];

    public CellBuilder(List<IndicatorDefinition> indicators) {
        this.indicators = indicators;
        this.filter = Filter.None;
        this.slices = Collections.emptyList();
    }

    public CellBuilder(List<IndicatorDefinition> indicators, List<Slice> slices) {
        this.indicators = indicators;
        this.filter = SliceFilter.of(slices);
        this.slices = slices;
    }

    public void setAccumulators(Accumulator[] accumulators) {
        this.accumulators = accumulators;
    }

    public void add(Fact fact) {
        boolean isAccepted = this.filter.accepts(fact.idx());
        for (Accumulator accumulator : this.accumulators) {
            Object value = fact.value(accumulator.name());
            accumulator.addTotal(value);
            if (!isAccepted) continue;
            accumulator.add(value);
        }
    }

    public String toString() {
        return this.slices.stream().map(Slice::name).collect(Collectors.joining("-"));
    }

    public Cube.Cell cell(Iterable<Fact> facts) {
        return new CellImpl(facts);
    }

    public List<Slice> slices() {
        return this.slices;
    }

    public List<IndicatorDefinition> indicators() {
        return this.indicators;
    }

    public Filter filter() {
        return this.filter;
    }

    public Accumulator[] accumulators() {
        return this.accumulators;
    }

    public class CellImpl
    implements Cube.Cell {
        private Map<String, Cube.Indicator> indicatorValueMap;
        private final Iterable<Fact> facts;

        public CellImpl(Iterable<Fact> facts) {
            this.facts = facts;
        }

        public List<Accumulator> accumulators() {
            return Arrays.asList(CellBuilder.this.accumulators);
        }

        @Override
        public List<? extends Slice> slices() {
            return CellBuilder.this.slices;
        }

        @Override
        public List<? extends Cube.Indicator> indicators() {
            return new ArrayList<Cube.Indicator>(this.indicatorsMap().values());
        }

        @Override
        public Map<String, ? extends Cube.Indicator> indicatorsMap() {
            if (this.indicatorValueMap == null) {
                this.indicatorValueMap = this.translate(this.calculations());
            }
            return this.indicatorValueMap;
        }

        private Map<String, Cube.Indicator> translate(Map<String, Cube.Indicator> calculations) {
            LinkedHashMap<String, Cube.Indicator> map = new LinkedHashMap<String, Cube.Indicator>();
            CellBuilder.this.indicators.forEach(i -> {
                Cube.Indicator indicator;
                Cube.Indicator indicator2 = indicator = i.isComposite() ? this.indicator((Map<String, Cube.Indicator>)map, i.asComposite()) : this.indicator(calculations, i.asSimple());
                if (indicator == null) {
                    return;
                }
                map.put(i.name(), indicator);
            });
            return map;
        }

        private Cube.Indicator indicator(Map<String, Cube.Indicator> calculations, SimpleIndicatorDefinition d) {
            return calculations.getOrDefault(d.label(), Cube.Indicator.None).as(d.name(), d.unit(), this.ratio(d.scale()));
        }

        private Cube.Indicator indicator(Map<String, Cube.Indicator> map, CompositeIndicatorDefinition c) {
            Cube.Indicator i2;
            Cube.Indicator i1 = map.get(c.indicator1());
            Object value = CompositeCalculator.calculate(c, i1, i2 = map.get(c.indicator2()));
            if (value == null) {
                return null;
            }
            return Cube.indicator(c.name(), value).as(c.name(), c.unit(), this.ratio(c.scale()));
        }

        private double ratio(IndicatorDefinition.Scale scale) {
            return scale == null ? 1.0 : scale.ratio();
        }

        private Map<String, Cube.Indicator> calculations() {
            return Arrays.stream(CellBuilder.this.accumulators).flatMap(a -> a.indicators().stream()).collect(Collectors.toMap(Cube.Indicator::name, i -> i, (a, b) -> a));
        }

        @Override
        public Iterable<Fact> facts() {
            return this.facts;
        }

        public String toString() {
            return CellBuilder.this.slices.stream().map(Object::toString).collect(Collectors.joining("-"));
        }
    }
}

